package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  EndpointName,
  MonitoringJobDefinitionName,
  MonitoringScheduleName,
  Timestamp,
  MaxResults
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListMonitoringExecutionsRequest(
    monitoringScheduleName: Option[MonitoringScheduleName] = None,
    endpointName: Option[EndpointName] = None,
    sortBy: Option[zio.aws.sagemaker.model.MonitoringExecutionSortKey] = None,
    sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    scheduledTimeBefore: Option[Timestamp] = None,
    scheduledTimeAfter: Option[Timestamp] = None,
    creationTimeBefore: Option[Timestamp] = None,
    creationTimeAfter: Option[Timestamp] = None,
    lastModifiedTimeBefore: Option[Timestamp] = None,
    lastModifiedTimeAfter: Option[Timestamp] = None,
    statusEquals: Option[zio.aws.sagemaker.model.ExecutionStatus] = None,
    monitoringJobDefinitionName: Option[MonitoringJobDefinitionName] = None,
    monitoringTypeEquals: Option[zio.aws.sagemaker.model.MonitoringType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsRequest = {
    import ListMonitoringExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsRequest
      .builder()
      .optionallyWith(
        monitoringScheduleName.map(value =>
          MonitoringScheduleName.unwrap(value): java.lang.String
        )
      )(_.monitoringScheduleName)
      .optionallyWith(
        endpointName.map(value => EndpointName.unwrap(value): java.lang.String)
      )(_.endpointName)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        scheduledTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.scheduledTimeBefore)
      .optionallyWith(
        scheduledTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.scheduledTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        lastModifiedTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTimeBefore)
      .optionallyWith(
        lastModifiedTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTimeAfter)
      .optionallyWith(statusEquals.map(value => value.unwrap))(_.statusEquals)
      .optionallyWith(
        monitoringJobDefinitionName.map(value =>
          MonitoringJobDefinitionName.unwrap(value): java.lang.String
        )
      )(_.monitoringJobDefinitionName)
      .optionallyWith(monitoringTypeEquals.map(value => value.unwrap))(
        _.monitoringTypeEquals
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListMonitoringExecutionsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListMonitoringExecutionsRequest
      .wrap(buildAwsValue())
}
object ListMonitoringExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListMonitoringExecutionsRequest =
      zio.aws.sagemaker.model.ListMonitoringExecutionsRequest(
        monitoringScheduleName.map(value => value),
        endpointName.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        scheduledTimeBefore.map(value => value),
        scheduledTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        creationTimeAfter.map(value => value),
        lastModifiedTimeBefore.map(value => value),
        lastModifiedTimeAfter.map(value => value),
        statusEquals.map(value => value),
        monitoringJobDefinitionName.map(value => value),
        monitoringTypeEquals.map(value => value)
      )
    def monitoringScheduleName: Option[MonitoringScheduleName]
    def endpointName: Option[EndpointName]
    def sortBy: Option[zio.aws.sagemaker.model.MonitoringExecutionSortKey]
    def sortOrder: Option[zio.aws.sagemaker.model.SortOrder]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def scheduledTimeBefore: Option[Timestamp]
    def scheduledTimeAfter: Option[Timestamp]
    def creationTimeBefore: Option[Timestamp]
    def creationTimeAfter: Option[Timestamp]
    def lastModifiedTimeBefore: Option[Timestamp]
    def lastModifiedTimeAfter: Option[Timestamp]
    def statusEquals: Option[zio.aws.sagemaker.model.ExecutionStatus]
    def monitoringJobDefinitionName: Option[MonitoringJobDefinitionName]
    def monitoringTypeEquals: Option[zio.aws.sagemaker.model.MonitoringType]
    def getMonitoringScheduleName: ZIO[Any, AwsError, MonitoringScheduleName] =
      AwsError.unwrapOptionField(
        "monitoringScheduleName",
        monitoringScheduleName
      )
    def getEndpointName: ZIO[Any, AwsError, EndpointName] =
      AwsError.unwrapOptionField("endpointName", endpointName)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringExecutionSortKey
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getScheduledTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("scheduledTimeBefore", scheduledTimeBefore)
    def getScheduledTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("scheduledTimeAfter", scheduledTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getLastModifiedTimeBefore: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastModifiedTimeBefore", lastModifiedTimeBefore)
    def getLastModifiedTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTimeAfter", lastModifiedTimeAfter)
    def getStatusEquals
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ExecutionStatus] =
      AwsError.unwrapOptionField("statusEquals", statusEquals)
    def getMonitoringJobDefinitionName
        : ZIO[Any, AwsError, MonitoringJobDefinitionName] =
      AwsError.unwrapOptionField(
        "monitoringJobDefinitionName",
        monitoringJobDefinitionName
      )
    def getMonitoringTypeEquals
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MonitoringType] =
      AwsError.unwrapOptionField("monitoringTypeEquals", monitoringTypeEquals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsRequest
  ) extends zio.aws.sagemaker.model.ListMonitoringExecutionsRequest.ReadOnly {
    override val monitoringScheduleName: Option[MonitoringScheduleName] = scala
      .Option(impl.monitoringScheduleName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.MonitoringScheduleName(value)
      )
    override val endpointName: Option[EndpointName] = scala
      .Option(impl.endpointName())
      .map(value => zio.aws.sagemaker.model.primitives.EndpointName(value))
    override val sortBy
        : Option[zio.aws.sagemaker.model.MonitoringExecutionSortKey] = scala
      .Option(impl.sortBy())
      .map(value =>
        zio.aws.sagemaker.model.MonitoringExecutionSortKey.wrap(value)
      )
    override val sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val scheduledTimeBefore: Option[Timestamp] = scala
      .Option(impl.scheduledTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val scheduledTimeAfter: Option[Timestamp] = scala
      .Option(impl.scheduledTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeBefore: Option[Timestamp] = scala
      .Option(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeAfter: Option[Timestamp] = scala
      .Option(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTimeBefore: Option[Timestamp] = scala
      .Option(impl.lastModifiedTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTimeAfter: Option[Timestamp] = scala
      .Option(impl.lastModifiedTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val statusEquals: Option[zio.aws.sagemaker.model.ExecutionStatus] =
      scala
        .Option(impl.statusEquals())
        .map(value => zio.aws.sagemaker.model.ExecutionStatus.wrap(value))
    override val monitoringJobDefinitionName
        : Option[MonitoringJobDefinitionName] = scala
      .Option(impl.monitoringJobDefinitionName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.MonitoringJobDefinitionName(value)
      )
    override val monitoringTypeEquals
        : Option[zio.aws.sagemaker.model.MonitoringType] = scala
      .Option(impl.monitoringTypeEquals())
      .map(value => zio.aws.sagemaker.model.MonitoringType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsRequest
  ): zio.aws.sagemaker.model.ListMonitoringExecutionsRequest.ReadOnly =
    new Wrapper(impl)
}
