package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListEndpointsResponse(
    endpoints: Iterable[zio.aws.sagemaker.model.EndpointSummary],
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListEndpointsResponse = {
    import ListEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListEndpointsResponse
      .builder()
      .endpoints(endpoints.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListEndpointsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListEndpointsResponse.wrap(buildAwsValue())
}
object ListEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListEndpointsResponse =
      zio.aws.sagemaker.model.ListEndpointsResponse(
        endpoints.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def endpoints: List[zio.aws.sagemaker.model.EndpointSummary.ReadOnly]
    def nextToken: Option[PaginationToken]
    def getEndpoints: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.EndpointSummary.ReadOnly
    ]] = ZIO.succeed(endpoints)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListEndpointsResponse
  ) extends zio.aws.sagemaker.model.ListEndpointsResponse.ReadOnly {
    override val endpoints
        : List[zio.aws.sagemaker.model.EndpointSummary.ReadOnly] = impl
      .endpoints()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.EndpointSummary.wrap(item)
      }
      .toList
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListEndpointsResponse
  ): zio.aws.sagemaker.model.ListEndpointsResponse.ReadOnly = new Wrapper(impl)
}
