package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  EndpointConfigNameContains,
  MaxResults,
  PaginationToken
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListEndpointConfigsRequest(
    sortBy: Option[zio.aws.sagemaker.model.EndpointConfigSortKey] = None,
    sortOrder: Option[zio.aws.sagemaker.model.OrderKey] = None,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[MaxResults] = None,
    nameContains: Option[EndpointConfigNameContains] = None,
    creationTimeBefore: Option[Timestamp] = None,
    creationTimeAfter: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest = {
    import ListEndpointConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest
      .builder()
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nameContains.map(value =>
          EndpointConfigNameContains.unwrap(value): java.lang.String
        )
      )(_.nameContains)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListEndpointConfigsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListEndpointConfigsRequest.wrap(buildAwsValue())
}
object ListEndpointConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListEndpointConfigsRequest =
      zio.aws.sagemaker.model.ListEndpointConfigsRequest(
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        nameContains.map(value => value),
        creationTimeBefore.map(value => value),
        creationTimeAfter.map(value => value)
      )
    def sortBy: Option[zio.aws.sagemaker.model.EndpointConfigSortKey]
    def sortOrder: Option[zio.aws.sagemaker.model.OrderKey]
    def nextToken: Option[PaginationToken]
    def maxResults: Option[MaxResults]
    def nameContains: Option[EndpointConfigNameContains]
    def creationTimeBefore: Option[Timestamp]
    def creationTimeAfter: Option[Timestamp]
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.EndpointConfigSortKey] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.OrderKey] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNameContains: ZIO[Any, AwsError, EndpointConfigNameContains] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest
  ) extends zio.aws.sagemaker.model.ListEndpointConfigsRequest.ReadOnly {
    override val sortBy: Option[zio.aws.sagemaker.model.EndpointConfigSortKey] =
      scala
        .Option(impl.sortBy())
        .map(value => zio.aws.sagemaker.model.EndpointConfigSortKey.wrap(value))
    override val sortOrder: Option[zio.aws.sagemaker.model.OrderKey] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.sagemaker.model.OrderKey.wrap(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.PaginationToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val nameContains: Option[EndpointConfigNameContains] = scala
      .Option(impl.nameContains())
      .map(value =>
        zio.aws.sagemaker.model.primitives.EndpointConfigNameContains(value)
      )
    override val creationTimeBefore: Option[Timestamp] = scala
      .Option(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeAfter: Option[Timestamp] = scala
      .Option(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest
  ): zio.aws.sagemaker.model.ListEndpointConfigsRequest.ReadOnly = new Wrapper(
    impl
  )
}
