package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListDevicesResponse(
    deviceSummaries: Iterable[zio.aws.sagemaker.model.DeviceSummary],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListDevicesResponse = {
    import ListDevicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListDevicesResponse
      .builder()
      .deviceSummaries(deviceSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListDevicesResponse.ReadOnly =
    zio.aws.sagemaker.model.ListDevicesResponse.wrap(buildAwsValue())
}
object ListDevicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListDevicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListDevicesResponse =
      zio.aws.sagemaker.model.ListDevicesResponse(
        deviceSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def deviceSummaries: List[zio.aws.sagemaker.model.DeviceSummary.ReadOnly]
    def nextToken: Option[NextToken]
    def getDeviceSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.DeviceSummary.ReadOnly
    ]] = ZIO.succeed(deviceSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListDevicesResponse
  ) extends zio.aws.sagemaker.model.ListDevicesResponse.ReadOnly {
    override val deviceSummaries
        : List[zio.aws.sagemaker.model.DeviceSummary.ReadOnly] = impl
      .deviceSummaries()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.DeviceSummary.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListDevicesResponse
  ): zio.aws.sagemaker.model.ListDevicesResponse.ReadOnly = new Wrapper(impl)
}
