package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.String256
import scala.jdk.CollectionConverters.*
final case class LambdaStepMetadata(
    arn: Option[String256] = None,
    outputParameters: Option[
      Iterable[zio.aws.sagemaker.model.OutputParameter]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.LambdaStepMetadata = {
    import LambdaStepMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.LambdaStepMetadata
      .builder()
      .optionallyWith(
        arn.map(value => String256.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        outputParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputParameters)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.LambdaStepMetadata.ReadOnly =
    zio.aws.sagemaker.model.LambdaStepMetadata.wrap(buildAwsValue())
}
object LambdaStepMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.LambdaStepMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.LambdaStepMetadata =
      zio.aws.sagemaker.model.LambdaStepMetadata(
        arn.map(value => value),
        outputParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Option[String256]
    def outputParameters
        : Option[List[zio.aws.sagemaker.model.OutputParameter.ReadOnly]]
    def getArn: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("arn", arn)
    def getOutputParameters: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.OutputParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("outputParameters", outputParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.LambdaStepMetadata
  ) extends zio.aws.sagemaker.model.LambdaStepMetadata.ReadOnly {
    override val arn: Option[String256] = scala
      .Option(impl.arn())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val outputParameters
        : Option[List[zio.aws.sagemaker.model.OutputParameter.ReadOnly]] = scala
      .Option(impl.outputParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.OutputParameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.LambdaStepMetadata
  ): zio.aws.sagemaker.model.LambdaStepMetadata.ReadOnly = new Wrapper(impl)
}
