package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class KernelGatewayImageConfig(
    kernelSpecs: Iterable[zio.aws.sagemaker.model.KernelSpec],
    fileSystemConfig: Option[zio.aws.sagemaker.model.FileSystemConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.KernelGatewayImageConfig = {
    import KernelGatewayImageConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.KernelGatewayImageConfig
      .builder()
      .kernelSpecs(kernelSpecs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(fileSystemConfig.map(value => value.buildAwsValue()))(
        _.fileSystemConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.KernelGatewayImageConfig.ReadOnly =
    zio.aws.sagemaker.model.KernelGatewayImageConfig.wrap(buildAwsValue())
}
object KernelGatewayImageConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.KernelGatewayImageConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.KernelGatewayImageConfig =
      zio.aws.sagemaker.model.KernelGatewayImageConfig(
        kernelSpecs.map { item =>
          item.asEditable
        },
        fileSystemConfig.map(value => value.asEditable)
      )
    def kernelSpecs: List[zio.aws.sagemaker.model.KernelSpec.ReadOnly]
    def fileSystemConfig
        : Option[zio.aws.sagemaker.model.FileSystemConfig.ReadOnly]
    def getKernelSpecs
        : ZIO[Any, Nothing, List[zio.aws.sagemaker.model.KernelSpec.ReadOnly]] =
      ZIO.succeed(kernelSpecs)
    def getFileSystemConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.FileSystemConfig.ReadOnly
    ] = AwsError.unwrapOptionField("fileSystemConfig", fileSystemConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.KernelGatewayImageConfig
  ) extends zio.aws.sagemaker.model.KernelGatewayImageConfig.ReadOnly {
    override val kernelSpecs
        : List[zio.aws.sagemaker.model.KernelSpec.ReadOnly] = impl
      .kernelSpecs()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.KernelSpec.wrap(item)
      }
      .toList
    override val fileSystemConfig
        : Option[zio.aws.sagemaker.model.FileSystemConfig.ReadOnly] = scala
      .Option(impl.fileSystemConfig())
      .map(value => zio.aws.sagemaker.model.FileSystemConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.KernelGatewayImageConfig
  ): zio.aws.sagemaker.model.KernelGatewayImageConfig.ReadOnly = new Wrapper(
    impl
  )
}
