package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{KmsKeyId, S3Uri}
import scala.jdk.CollectionConverters.*
final case class FlowDefinitionOutputConfig(
    s3OutputPath: S3Uri,
    kmsKeyId: Option[KmsKeyId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.FlowDefinitionOutputConfig = {
    import FlowDefinitionOutputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.FlowDefinitionOutputConfig
      .builder()
      .s3OutputPath(S3Uri.unwrap(s3OutputPath): java.lang.String)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.FlowDefinitionOutputConfig.ReadOnly =
    zio.aws.sagemaker.model.FlowDefinitionOutputConfig.wrap(buildAwsValue())
}
object FlowDefinitionOutputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.FlowDefinitionOutputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.FlowDefinitionOutputConfig =
      zio.aws.sagemaker.model
        .FlowDefinitionOutputConfig(s3OutputPath, kmsKeyId.map(value => value))
    def s3OutputPath: S3Uri
    def kmsKeyId: Option[KmsKeyId]
    def getS3OutputPath: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3OutputPath)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.FlowDefinitionOutputConfig
  ) extends zio.aws.sagemaker.model.FlowDefinitionOutputConfig.ReadOnly {
    override val s3OutputPath: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.s3OutputPath())
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.FlowDefinitionOutputConfig
  ): zio.aws.sagemaker.model.FlowDefinitionOutputConfig.ReadOnly = new Wrapper(
    impl
  )
}
