package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{String1024, String256}
import scala.jdk.CollectionConverters.*
final case class EMRStepMetadata(
    clusterId: Option[String256] = None,
    stepId: Option[String256] = None,
    stepName: Option[String256] = None,
    logFilePath: Option[String1024] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.EMRStepMetadata = {
    import EMRStepMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.EMRStepMetadata
      .builder()
      .optionallyWith(
        clusterId.map(value => String256.unwrap(value): java.lang.String)
      )(_.clusterId)
      .optionallyWith(
        stepId.map(value => String256.unwrap(value): java.lang.String)
      )(_.stepId)
      .optionallyWith(
        stepName.map(value => String256.unwrap(value): java.lang.String)
      )(_.stepName)
      .optionallyWith(
        logFilePath.map(value => String1024.unwrap(value): java.lang.String)
      )(_.logFilePath)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.EMRStepMetadata.ReadOnly =
    zio.aws.sagemaker.model.EMRStepMetadata.wrap(buildAwsValue())
}
object EMRStepMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.EMRStepMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.EMRStepMetadata =
      zio.aws.sagemaker.model.EMRStepMetadata(
        clusterId.map(value => value),
        stepId.map(value => value),
        stepName.map(value => value),
        logFilePath.map(value => value)
      )
    def clusterId: Option[String256]
    def stepId: Option[String256]
    def stepName: Option[String256]
    def logFilePath: Option[String1024]
    def getClusterId: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("clusterId", clusterId)
    def getStepId: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("stepId", stepId)
    def getStepName: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("stepName", stepName)
    def getLogFilePath: ZIO[Any, AwsError, String1024] =
      AwsError.unwrapOptionField("logFilePath", logFilePath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.EMRStepMetadata
  ) extends zio.aws.sagemaker.model.EMRStepMetadata.ReadOnly {
    override val clusterId: Option[String256] = scala
      .Option(impl.clusterId())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val stepId: Option[String256] = scala
      .Option(impl.stepId())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val stepName: Option[String256] = scala
      .Option(impl.stepName())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val logFilePath: Option[String1024] = scala
      .Option(impl.logFilePath())
      .map(value => zio.aws.sagemaker.model.primitives.String1024(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.EMRStepMetadata
  ): zio.aws.sagemaker.model.EMRStepMetadata.ReadOnly = new Wrapper(impl)
}
