package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  RecommendationJobName,
  RoleArn,
  Timestamp,
  FailureReason,
  LastModifiedTime,
  RecommendationJobArn,
  RecommendationJobDescription
}
import scala.jdk.CollectionConverters.*
final case class DescribeInferenceRecommendationsJobResponse(
    jobName: RecommendationJobName,
    jobDescription: Option[RecommendationJobDescription] = None,
    jobType: zio.aws.sagemaker.model.RecommendationJobType,
    jobArn: RecommendationJobArn,
    roleArn: RoleArn,
    status: zio.aws.sagemaker.model.RecommendationJobStatus,
    creationTime: CreationTime,
    completionTime: Option[Timestamp] = None,
    lastModifiedTime: LastModifiedTime,
    failureReason: Option[FailureReason] = None,
    inputConfig: zio.aws.sagemaker.model.RecommendationJobInputConfig,
    stoppingConditions: Option[
      zio.aws.sagemaker.model.RecommendationJobStoppingConditions
    ] = None,
    inferenceRecommendations: Option[
      Iterable[zio.aws.sagemaker.model.InferenceRecommendation]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeInferenceRecommendationsJobResponse = {
    import DescribeInferenceRecommendationsJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeInferenceRecommendationsJobResponse
      .builder()
      .jobName(RecommendationJobName.unwrap(jobName): java.lang.String)
      .optionallyWith(
        jobDescription.map(value =>
          RecommendationJobDescription.unwrap(value): java.lang.String
        )
      )(_.jobDescription)
      .jobType(jobType.unwrap)
      .jobArn(RecommendationJobArn.unwrap(jobArn): java.lang.String)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .status(status.unwrap)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .optionallyWith(
        completionTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.completionTime)
      .lastModifiedTime(LastModifiedTime.unwrap(lastModifiedTime): Instant)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .inputConfig(inputConfig.buildAwsValue())
      .optionallyWith(stoppingConditions.map(value => value.buildAwsValue()))(
        _.stoppingConditions
      )
      .optionallyWith(
        inferenceRecommendations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inferenceRecommendations)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeInferenceRecommendationsJobResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeInferenceRecommendationsJobResponse
      .wrap(buildAwsValue())
}
object DescribeInferenceRecommendationsJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeInferenceRecommendationsJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DescribeInferenceRecommendationsJobResponse =
      zio.aws.sagemaker.model.DescribeInferenceRecommendationsJobResponse(
        jobName,
        jobDescription.map(value => value),
        jobType,
        jobArn,
        roleArn,
        status,
        creationTime,
        completionTime.map(value => value),
        lastModifiedTime,
        failureReason.map(value => value),
        inputConfig.asEditable,
        stoppingConditions.map(value => value.asEditable),
        inferenceRecommendations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobName: RecommendationJobName
    def jobDescription: Option[RecommendationJobDescription]
    def jobType: zio.aws.sagemaker.model.RecommendationJobType
    def jobArn: RecommendationJobArn
    def roleArn: RoleArn
    def status: zio.aws.sagemaker.model.RecommendationJobStatus
    def creationTime: CreationTime
    def completionTime: Option[Timestamp]
    def lastModifiedTime: LastModifiedTime
    def failureReason: Option[FailureReason]
    def inputConfig
        : zio.aws.sagemaker.model.RecommendationJobInputConfig.ReadOnly
    def stoppingConditions: Option[
      zio.aws.sagemaker.model.RecommendationJobStoppingConditions.ReadOnly
    ]
    def inferenceRecommendations
        : Option[List[zio.aws.sagemaker.model.InferenceRecommendation.ReadOnly]]
    def getJobName: ZIO[Any, Nothing, RecommendationJobName] =
      ZIO.succeed(jobName)
    def getJobDescription: ZIO[Any, AwsError, RecommendationJobDescription] =
      AwsError.unwrapOptionField("jobDescription", jobDescription)
    def getJobType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.RecommendationJobType] =
      ZIO.succeed(jobType)
    def getJobArn: ZIO[Any, Nothing, RecommendationJobArn] = ZIO.succeed(jobArn)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.RecommendationJobStatus] =
      ZIO.succeed(status)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getCompletionTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getLastModifiedTime: ZIO[Any, Nothing, LastModifiedTime] =
      ZIO.succeed(lastModifiedTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getInputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.RecommendationJobInputConfig.ReadOnly
    ] = ZIO.succeed(inputConfig)
    def getStoppingConditions: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RecommendationJobStoppingConditions.ReadOnly
    ] = AwsError.unwrapOptionField("stoppingConditions", stoppingConditions)
    def getInferenceRecommendations: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.InferenceRecommendation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "inferenceRecommendations",
      inferenceRecommendations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeInferenceRecommendationsJobResponse
  ) extends zio.aws.sagemaker.model.DescribeInferenceRecommendationsJobResponse.ReadOnly {
    override val jobName: RecommendationJobName =
      zio.aws.sagemaker.model.primitives.RecommendationJobName(impl.jobName())
    override val jobDescription: Option[RecommendationJobDescription] = scala
      .Option(impl.jobDescription())
      .map(value =>
        zio.aws.sagemaker.model.primitives.RecommendationJobDescription(value)
      )
    override val jobType: zio.aws.sagemaker.model.RecommendationJobType =
      zio.aws.sagemaker.model.RecommendationJobType.wrap(impl.jobType())
    override val jobArn: RecommendationJobArn =
      zio.aws.sagemaker.model.primitives.RecommendationJobArn(impl.jobArn())
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val status: zio.aws.sagemaker.model.RecommendationJobStatus =
      zio.aws.sagemaker.model.RecommendationJobStatus.wrap(impl.status())
    override val creationTime: CreationTime =
      zio.aws.sagemaker.model.primitives.CreationTime(impl.creationTime())
    override val completionTime: Option[Timestamp] = scala
      .Option(impl.completionTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: LastModifiedTime =
      zio.aws.sagemaker.model.primitives
        .LastModifiedTime(impl.lastModifiedTime())
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val inputConfig
        : zio.aws.sagemaker.model.RecommendationJobInputConfig.ReadOnly =
      zio.aws.sagemaker.model.RecommendationJobInputConfig
        .wrap(impl.inputConfig())
    override val stoppingConditions: Option[
      zio.aws.sagemaker.model.RecommendationJobStoppingConditions.ReadOnly
    ] = scala
      .Option(impl.stoppingConditions())
      .map(value =>
        zio.aws.sagemaker.model.RecommendationJobStoppingConditions.wrap(value)
      )
    override val inferenceRecommendations: Option[
      List[zio.aws.sagemaker.model.InferenceRecommendation.ReadOnly]
    ] = scala
      .Option(impl.inferenceRecommendations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.InferenceRecommendation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeInferenceRecommendationsJobResponse
  ): zio.aws.sagemaker.model.DescribeInferenceRecommendationsJobResponse.ReadOnly =
    new Wrapper(impl)
}
