package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.ProcessingJobName
import scala.jdk.CollectionConverters.*
final case class DataQualityBaselineConfig(
    baseliningJobName: Option[ProcessingJobName] = None,
    constraintsResource: Option[
      zio.aws.sagemaker.model.MonitoringConstraintsResource
    ] = None,
    statisticsResource: Option[
      zio.aws.sagemaker.model.MonitoringStatisticsResource
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DataQualityBaselineConfig = {
    import DataQualityBaselineConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DataQualityBaselineConfig
      .builder()
      .optionallyWith(
        baseliningJobName.map(value =>
          ProcessingJobName.unwrap(value): java.lang.String
        )
      )(_.baseliningJobName)
      .optionallyWith(constraintsResource.map(value => value.buildAwsValue()))(
        _.constraintsResource
      )
      .optionallyWith(statisticsResource.map(value => value.buildAwsValue()))(
        _.statisticsResource
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DataQualityBaselineConfig.ReadOnly =
    zio.aws.sagemaker.model.DataQualityBaselineConfig.wrap(buildAwsValue())
}
object DataQualityBaselineConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DataQualityBaselineConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DataQualityBaselineConfig =
      zio.aws.sagemaker.model.DataQualityBaselineConfig(
        baseliningJobName.map(value => value),
        constraintsResource.map(value => value.asEditable),
        statisticsResource.map(value => value.asEditable)
      )
    def baseliningJobName: Option[ProcessingJobName]
    def constraintsResource
        : Option[zio.aws.sagemaker.model.MonitoringConstraintsResource.ReadOnly]
    def statisticsResource
        : Option[zio.aws.sagemaker.model.MonitoringStatisticsResource.ReadOnly]
    def getBaseliningJobName: ZIO[Any, AwsError, ProcessingJobName] =
      AwsError.unwrapOptionField("baseliningJobName", baseliningJobName)
    def getConstraintsResource: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringConstraintsResource.ReadOnly
    ] = AwsError.unwrapOptionField("constraintsResource", constraintsResource)
    def getStatisticsResource: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringStatisticsResource.ReadOnly
    ] = AwsError.unwrapOptionField("statisticsResource", statisticsResource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DataQualityBaselineConfig
  ) extends zio.aws.sagemaker.model.DataQualityBaselineConfig.ReadOnly {
    override val baseliningJobName: Option[ProcessingJobName] = scala
      .Option(impl.baseliningJobName())
      .map(value => zio.aws.sagemaker.model.primitives.ProcessingJobName(value))
    override val constraintsResource: Option[
      zio.aws.sagemaker.model.MonitoringConstraintsResource.ReadOnly
    ] = scala
      .Option(impl.constraintsResource())
      .map(value =>
        zio.aws.sagemaker.model.MonitoringConstraintsResource.wrap(value)
      )
    override val statisticsResource: Option[
      zio.aws.sagemaker.model.MonitoringStatisticsResource.ReadOnly
    ] = scala
      .Option(impl.statisticsResource())
      .map(value =>
        zio.aws.sagemaker.model.MonitoringStatisticsResource.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DataQualityBaselineConfig
  ): zio.aws.sagemaker.model.DataQualityBaselineConfig.ReadOnly = new Wrapper(
    impl
  )
}
