package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  String200,
  WorkforceName,
  WorkteamName
}
import scala.jdk.CollectionConverters.*
final case class CreateWorkteamRequest(
    workteamName: WorkteamName,
    workforceName: Option[WorkforceName] = None,
    memberDefinitions: Iterable[zio.aws.sagemaker.model.MemberDefinition],
    description: String200,
    notificationConfiguration: Option[
      zio.aws.sagemaker.model.NotificationConfiguration
    ] = None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateWorkteamRequest = {
    import CreateWorkteamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateWorkteamRequest
      .builder()
      .workteamName(WorkteamName.unwrap(workteamName): java.lang.String)
      .optionallyWith(
        workforceName.map(value =>
          WorkforceName.unwrap(value): java.lang.String
        )
      )(_.workforceName)
      .memberDefinitions(memberDefinitions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .description(String200.unwrap(description): java.lang.String)
      .optionallyWith(
        notificationConfiguration.map(value => value.buildAwsValue())
      )(_.notificationConfiguration)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateWorkteamRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateWorkteamRequest.wrap(buildAwsValue())
}
object CreateWorkteamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateWorkteamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateWorkteamRequest =
      zio.aws.sagemaker.model.CreateWorkteamRequest(
        workteamName,
        workforceName.map(value => value),
        memberDefinitions.map { item =>
          item.asEditable
        },
        description,
        notificationConfiguration.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def workteamName: WorkteamName
    def workforceName: Option[WorkforceName]
    def memberDefinitions
        : List[zio.aws.sagemaker.model.MemberDefinition.ReadOnly]
    def description: String200
    def notificationConfiguration
        : Option[zio.aws.sagemaker.model.NotificationConfiguration.ReadOnly]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getWorkteamName: ZIO[Any, Nothing, WorkteamName] =
      ZIO.succeed(workteamName)
    def getWorkforceName: ZIO[Any, AwsError, WorkforceName] =
      AwsError.unwrapOptionField("workforceName", workforceName)
    def getMemberDefinitions: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.MemberDefinition.ReadOnly
    ]] = ZIO.succeed(memberDefinitions)
    def getDescription: ZIO[Any, Nothing, String200] = ZIO.succeed(description)
    def getNotificationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.NotificationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "notificationConfiguration",
      notificationConfiguration
    )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateWorkteamRequest
  ) extends zio.aws.sagemaker.model.CreateWorkteamRequest.ReadOnly {
    override val workteamName: WorkteamName =
      zio.aws.sagemaker.model.primitives.WorkteamName(impl.workteamName())
    override val workforceName: Option[WorkforceName] = scala
      .Option(impl.workforceName())
      .map(value => zio.aws.sagemaker.model.primitives.WorkforceName(value))
    override val memberDefinitions
        : List[zio.aws.sagemaker.model.MemberDefinition.ReadOnly] = impl
      .memberDefinitions()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.MemberDefinition.wrap(item)
      }
      .toList
    override val description: String200 =
      zio.aws.sagemaker.model.primitives.String200(impl.description())
    override val notificationConfiguration
        : Option[zio.aws.sagemaker.model.NotificationConfiguration.ReadOnly] =
      scala
        .Option(impl.notificationConfiguration())
        .map(value =>
          zio.aws.sagemaker.model.NotificationConfiguration.wrap(value)
        )
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateWorkteamRequest
  ): zio.aws.sagemaker.model.CreateWorkteamRequest.ReadOnly = new Wrapper(impl)
}
