package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.ImageArn
import scala.jdk.CollectionConverters.*
final case class CreateImageResponse(imageArn: Option[ImageArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateImageResponse = {
    import CreateImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateImageResponse
      .builder()
      .optionallyWith(
        imageArn.map(value => ImageArn.unwrap(value): java.lang.String)
      )(_.imageArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateImageResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateImageResponse.wrap(buildAwsValue())
}
object CreateImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateImageResponse =
      zio.aws.sagemaker.model.CreateImageResponse(imageArn.map(value => value))
    def imageArn: Option[ImageArn]
    def getImageArn: ZIO[Any, AwsError, ImageArn] =
      AwsError.unwrapOptionField("imageArn", imageArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateImageResponse
  ) extends zio.aws.sagemaker.model.CreateImageResponse.ReadOnly {
    override val imageArn: Option[ImageArn] = scala
      .Option(impl.imageArn())
      .map(value => zio.aws.sagemaker.model.primitives.ImageArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateImageResponse
  ): zio.aws.sagemaker.model.CreateImageResponse.ReadOnly = new Wrapper(impl)
}
