package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.PipelineExecutionArn
import scala.jdk.CollectionConverters.*
final case class CacheHitResult(
    sourcePipelineExecutionArn: Option[PipelineExecutionArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CacheHitResult = {
    import CacheHitResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CacheHitResult
      .builder()
      .optionallyWith(
        sourcePipelineExecutionArn.map(value =>
          PipelineExecutionArn.unwrap(value): java.lang.String
        )
      )(_.sourcePipelineExecutionArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CacheHitResult.ReadOnly =
    zio.aws.sagemaker.model.CacheHitResult.wrap(buildAwsValue())
}
object CacheHitResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CacheHitResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CacheHitResult =
      zio.aws.sagemaker.model
        .CacheHitResult(sourcePipelineExecutionArn.map(value => value))
    def sourcePipelineExecutionArn: Option[PipelineExecutionArn]
    def getSourcePipelineExecutionArn
        : ZIO[Any, AwsError, PipelineExecutionArn] = AwsError.unwrapOptionField(
      "sourcePipelineExecutionArn",
      sourcePipelineExecutionArn
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CacheHitResult
  ) extends zio.aws.sagemaker.model.CacheHitResult.ReadOnly {
    override val sourcePipelineExecutionArn: Option[PipelineExecutionArn] =
      scala
        .Option(impl.sourcePipelineExecutionArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.PipelineExecutionArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CacheHitResult
  ): zio.aws.sagemaker.model.CacheHitResult.ReadOnly = new Wrapper(impl)
}
