package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.ModelPackageArn
import scala.jdk.CollectionConverters.*
final case class BatchDescribeModelPackageResponse(
    modelPackageSummaries: Option[Map[
      ModelPackageArn,
      zio.aws.sagemaker.model.BatchDescribeModelPackageSummary
    ]] = None,
    batchDescribeModelPackageErrorMap: Option[Map[
      ModelPackageArn,
      zio.aws.sagemaker.model.BatchDescribeModelPackageError
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageResponse = {
    import BatchDescribeModelPackageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageResponse
      .builder()
      .optionallyWith(
        modelPackageSummaries.map(value =>
          value
            .map({ case (key, value) =>
              (ModelPackageArn.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.modelPackageSummaries)
      .optionallyWith(
        batchDescribeModelPackageErrorMap.map(value =>
          value
            .map({ case (key, value) =>
              (ModelPackageArn.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.batchDescribeModelPackageErrorMap)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.BatchDescribeModelPackageResponse.ReadOnly =
    zio.aws.sagemaker.model.BatchDescribeModelPackageResponse
      .wrap(buildAwsValue())
}
object BatchDescribeModelPackageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.BatchDescribeModelPackageResponse =
      zio.aws.sagemaker.model.BatchDescribeModelPackageResponse(
        modelPackageSummaries.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        batchDescribeModelPackageErrorMap.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def modelPackageSummaries: Option[Map[
      ModelPackageArn,
      zio.aws.sagemaker.model.BatchDescribeModelPackageSummary.ReadOnly
    ]]
    def batchDescribeModelPackageErrorMap: Option[Map[
      ModelPackageArn,
      zio.aws.sagemaker.model.BatchDescribeModelPackageError.ReadOnly
    ]]
    def getModelPackageSummaries: ZIO[Any, AwsError, Map[
      ModelPackageArn,
      zio.aws.sagemaker.model.BatchDescribeModelPackageSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("modelPackageSummaries", modelPackageSummaries)
    def getBatchDescribeModelPackageErrorMap: ZIO[Any, AwsError, Map[
      ModelPackageArn,
      zio.aws.sagemaker.model.BatchDescribeModelPackageError.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "batchDescribeModelPackageErrorMap",
      batchDescribeModelPackageErrorMap
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageResponse
  ) extends zio.aws.sagemaker.model.BatchDescribeModelPackageResponse.ReadOnly {
    override val modelPackageSummaries: Option[Map[
      ModelPackageArn,
      zio.aws.sagemaker.model.BatchDescribeModelPackageSummary.ReadOnly
    ]] = scala
      .Option(impl.modelPackageSummaries())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.ModelPackageArn(
              key
            ) -> zio.aws.sagemaker.model.BatchDescribeModelPackageSummary
              .wrap(value)
          })
          .toMap
      )
    override val batchDescribeModelPackageErrorMap: Option[Map[
      ModelPackageArn,
      zio.aws.sagemaker.model.BatchDescribeModelPackageError.ReadOnly
    ]] = scala
      .Option(impl.batchDescribeModelPackageErrorMap())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.ModelPackageArn(
              key
            ) -> zio.aws.sagemaker.model.BatchDescribeModelPackageError
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageResponse
  ): zio.aws.sagemaker.model.BatchDescribeModelPackageResponse.ReadOnly =
    new Wrapper(impl)
}
