package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AutoMLJobConfig(
    completionCriteria: Option[
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria
    ] = None,
    securityConfig: Option[zio.aws.sagemaker.model.AutoMLSecurityConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoMLJobConfig = {
    import AutoMLJobConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoMLJobConfig
      .builder()
      .optionallyWith(completionCriteria.map(value => value.buildAwsValue()))(
        _.completionCriteria
      )
      .optionallyWith(securityConfig.map(value => value.buildAwsValue()))(
        _.securityConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AutoMLJobConfig.ReadOnly =
    zio.aws.sagemaker.model.AutoMLJobConfig.wrap(buildAwsValue())
}
object AutoMLJobConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoMLJobConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoMLJobConfig =
      zio.aws.sagemaker.model.AutoMLJobConfig(
        completionCriteria.map(value => value.asEditable),
        securityConfig.map(value => value.asEditable)
      )
    def completionCriteria
        : Option[zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly]
    def securityConfig
        : Option[zio.aws.sagemaker.model.AutoMLSecurityConfig.ReadOnly]
    def getCompletionCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("completionCriteria", completionCriteria)
    def getSecurityConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLSecurityConfig.ReadOnly
    ] = AwsError.unwrapOptionField("securityConfig", securityConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLJobConfig
  ) extends zio.aws.sagemaker.model.AutoMLJobConfig.ReadOnly {
    override val completionCriteria
        : Option[zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly] =
      scala
        .Option(impl.completionCriteria())
        .map(value =>
          zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.wrap(value)
        )
    override val securityConfig
        : Option[zio.aws.sagemaker.model.AutoMLSecurityConfig.ReadOnly] = scala
      .Option(impl.securityConfig())
      .map(value => zio.aws.sagemaker.model.AutoMLSecurityConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLJobConfig
  ): zio.aws.sagemaker.model.AutoMLJobConfig.ReadOnly = new Wrapper(impl)
}
