package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{SecurityGroupId, RoleArn}
import scala.jdk.CollectionConverters.*
final case class UserSettings(
    executionRole: Option[RoleArn] = None,
    securityGroups: Option[Iterable[SecurityGroupId]] = None,
    sharingSettings: Option[zio.aws.sagemaker.model.SharingSettings] = None,
    jupyterServerAppSettings: Option[
      zio.aws.sagemaker.model.JupyterServerAppSettings
    ] = None,
    kernelGatewayAppSettings: Option[
      zio.aws.sagemaker.model.KernelGatewayAppSettings
    ] = None,
    tensorBoardAppSettings: Option[
      zio.aws.sagemaker.model.TensorBoardAppSettings
    ] = None,
    rStudioServerProAppSettings: Option[
      zio.aws.sagemaker.model.RStudioServerProAppSettings
    ] = None,
    rSessionAppSettings: Option[zio.aws.sagemaker.model.RSessionAppSettings] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UserSettings = {
    import UserSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UserSettings
      .builder()
      .optionallyWith(
        executionRole.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.executionRole)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(sharingSettings.map(value => value.buildAwsValue()))(
        _.sharingSettings
      )
      .optionallyWith(
        jupyterServerAppSettings.map(value => value.buildAwsValue())
      )(_.jupyterServerAppSettings)
      .optionallyWith(
        kernelGatewayAppSettings.map(value => value.buildAwsValue())
      )(_.kernelGatewayAppSettings)
      .optionallyWith(
        tensorBoardAppSettings.map(value => value.buildAwsValue())
      )(_.tensorBoardAppSettings)
      .optionallyWith(
        rStudioServerProAppSettings.map(value => value.buildAwsValue())
      )(_.rStudioServerProAppSettings)
      .optionallyWith(rSessionAppSettings.map(value => value.buildAwsValue()))(
        _.rSessionAppSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UserSettings.ReadOnly =
    zio.aws.sagemaker.model.UserSettings.wrap(buildAwsValue())
}
object UserSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UserSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UserSettings =
      zio.aws.sagemaker.model.UserSettings(
        executionRole.map(value => value),
        securityGroups.map(value => value),
        sharingSettings.map(value => value.asEditable),
        jupyterServerAppSettings.map(value => value.asEditable),
        kernelGatewayAppSettings.map(value => value.asEditable),
        tensorBoardAppSettings.map(value => value.asEditable),
        rStudioServerProAppSettings.map(value => value.asEditable),
        rSessionAppSettings.map(value => value.asEditable)
      )
    def executionRole: Option[RoleArn]
    def securityGroups: Option[List[SecurityGroupId]]
    def sharingSettings
        : Option[zio.aws.sagemaker.model.SharingSettings.ReadOnly]
    def jupyterServerAppSettings
        : Option[zio.aws.sagemaker.model.JupyterServerAppSettings.ReadOnly]
    def kernelGatewayAppSettings
        : Option[zio.aws.sagemaker.model.KernelGatewayAppSettings.ReadOnly]
    def tensorBoardAppSettings
        : Option[zio.aws.sagemaker.model.TensorBoardAppSettings.ReadOnly]
    def rStudioServerProAppSettings
        : Option[zio.aws.sagemaker.model.RStudioServerProAppSettings.ReadOnly]
    def rSessionAppSettings
        : Option[zio.aws.sagemaker.model.RSessionAppSettings.ReadOnly]
    def getExecutionRole: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("executionRole", executionRole)
    def getSecurityGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getSharingSettings
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.SharingSettings.ReadOnly] =
      AwsError.unwrapOptionField("sharingSettings", sharingSettings)
    def getJupyterServerAppSettings: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.JupyterServerAppSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jupyterServerAppSettings",
      jupyterServerAppSettings
    )
    def getKernelGatewayAppSettings: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.KernelGatewayAppSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kernelGatewayAppSettings",
      kernelGatewayAppSettings
    )
    def getTensorBoardAppSettings: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TensorBoardAppSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "tensorBoardAppSettings",
      tensorBoardAppSettings
    )
    def getRStudioServerProAppSettings: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RStudioServerProAppSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "rStudioServerProAppSettings",
      rStudioServerProAppSettings
    )
    def getRSessionAppSettings: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RSessionAppSettings.ReadOnly
    ] = AwsError.unwrapOptionField("rSessionAppSettings", rSessionAppSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UserSettings
  ) extends zio.aws.sagemaker.model.UserSettings.ReadOnly {
    override val executionRole: Option[RoleArn] = scala
      .Option(impl.executionRole())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val securityGroups: Option[List[SecurityGroupId]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val sharingSettings
        : Option[zio.aws.sagemaker.model.SharingSettings.ReadOnly] = scala
      .Option(impl.sharingSettings())
      .map(value => zio.aws.sagemaker.model.SharingSettings.wrap(value))
    override val jupyterServerAppSettings
        : Option[zio.aws.sagemaker.model.JupyterServerAppSettings.ReadOnly] =
      scala
        .Option(impl.jupyterServerAppSettings())
        .map(value =>
          zio.aws.sagemaker.model.JupyterServerAppSettings.wrap(value)
        )
    override val kernelGatewayAppSettings
        : Option[zio.aws.sagemaker.model.KernelGatewayAppSettings.ReadOnly] =
      scala
        .Option(impl.kernelGatewayAppSettings())
        .map(value =>
          zio.aws.sagemaker.model.KernelGatewayAppSettings.wrap(value)
        )
    override val tensorBoardAppSettings
        : Option[zio.aws.sagemaker.model.TensorBoardAppSettings.ReadOnly] =
      scala
        .Option(impl.tensorBoardAppSettings())
        .map(value =>
          zio.aws.sagemaker.model.TensorBoardAppSettings.wrap(value)
        )
    override val rStudioServerProAppSettings
        : Option[zio.aws.sagemaker.model.RStudioServerProAppSettings.ReadOnly] =
      scala
        .Option(impl.rStudioServerProAppSettings())
        .map(value =>
          zio.aws.sagemaker.model.RStudioServerProAppSettings.wrap(value)
        )
    override val rSessionAppSettings
        : Option[zio.aws.sagemaker.model.RSessionAppSettings.ReadOnly] = scala
      .Option(impl.rSessionAppSettings())
      .map(value => zio.aws.sagemaker.model.RSessionAppSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UserSettings
  ): zio.aws.sagemaker.model.UserSettings.ReadOnly = new Wrapper(impl)
}
