package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  TrialComponentKey64,
  TrialComponentKey256,
  Timestamp,
  ExperimentEntityName
}
import scala.jdk.CollectionConverters.*
final case class UpdateTrialComponentRequest(
    trialComponentName: ExperimentEntityName,
    displayName: Option[ExperimentEntityName] = None,
    status: Option[zio.aws.sagemaker.model.TrialComponentStatus] = None,
    startTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None,
    parameters: Option[Map[
      TrialComponentKey256,
      zio.aws.sagemaker.model.TrialComponentParameterValue
    ]] = None,
    parametersToRemove: Option[Iterable[TrialComponentKey256]] = None,
    inputArtifacts: Option[
      Map[TrialComponentKey64, zio.aws.sagemaker.model.TrialComponentArtifact]
    ] = None,
    inputArtifactsToRemove: Option[Iterable[TrialComponentKey256]] = None,
    outputArtifacts: Option[
      Map[TrialComponentKey64, zio.aws.sagemaker.model.TrialComponentArtifact]
    ] = None,
    outputArtifactsToRemove: Option[Iterable[TrialComponentKey256]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentRequest = {
    import UpdateTrialComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentRequest
      .builder()
      .trialComponentName(
        ExperimentEntityName.unwrap(trialComponentName): java.lang.String
      )
      .optionallyWith(
        displayName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (TrialComponentKey256.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        parametersToRemove.map(value =>
          value.map { item =>
            TrialComponentKey256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.parametersToRemove)
      .optionallyWith(
        inputArtifacts.map(value =>
          value
            .map({ case (key, value) =>
              (TrialComponentKey64.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.inputArtifacts)
      .optionallyWith(
        inputArtifactsToRemove.map(value =>
          value.map { item =>
            TrialComponentKey256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.inputArtifactsToRemove)
      .optionallyWith(
        outputArtifacts.map(value =>
          value
            .map({ case (key, value) =>
              (TrialComponentKey64.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.outputArtifacts)
      .optionallyWith(
        outputArtifactsToRemove.map(value =>
          value.map { item =>
            TrialComponentKey256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.outputArtifactsToRemove)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateTrialComponentRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateTrialComponentRequest.wrap(buildAwsValue())
}
object UpdateTrialComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateTrialComponentRequest =
      zio.aws.sagemaker.model.UpdateTrialComponentRequest(
        trialComponentName,
        displayName.map(value => value),
        status.map(value => value.asEditable),
        startTime.map(value => value),
        endTime.map(value => value),
        parameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        parametersToRemove.map(value => value),
        inputArtifacts.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        inputArtifactsToRemove.map(value => value),
        outputArtifacts.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        outputArtifactsToRemove.map(value => value)
      )
    def trialComponentName: ExperimentEntityName
    def displayName: Option[ExperimentEntityName]
    def status: Option[zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly]
    def startTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def parameters: Option[Map[
      TrialComponentKey256,
      zio.aws.sagemaker.model.TrialComponentParameterValue.ReadOnly
    ]]
    def parametersToRemove: Option[List[TrialComponentKey256]]
    def inputArtifacts: Option[Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]]
    def inputArtifactsToRemove: Option[List[TrialComponentKey256]]
    def outputArtifacts: Option[Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]]
    def outputArtifactsToRemove: Option[List[TrialComponentKey256]]
    def getTrialComponentName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(trialComponentName)
    def getDisplayName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getParameters: ZIO[Any, AwsError, Map[
      TrialComponentKey256,
      zio.aws.sagemaker.model.TrialComponentParameterValue.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getParametersToRemove: ZIO[Any, AwsError, List[TrialComponentKey256]] =
      AwsError.unwrapOptionField("parametersToRemove", parametersToRemove)
    def getInputArtifacts: ZIO[Any, AwsError, Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]] = AwsError.unwrapOptionField("inputArtifacts", inputArtifacts)
    def getInputArtifactsToRemove
        : ZIO[Any, AwsError, List[TrialComponentKey256]] = AwsError
      .unwrapOptionField("inputArtifactsToRemove", inputArtifactsToRemove)
    def getOutputArtifacts: ZIO[Any, AwsError, Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]] = AwsError.unwrapOptionField("outputArtifacts", outputArtifacts)
    def getOutputArtifactsToRemove
        : ZIO[Any, AwsError, List[TrialComponentKey256]] = AwsError
      .unwrapOptionField("outputArtifactsToRemove", outputArtifactsToRemove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentRequest
  ) extends zio.aws.sagemaker.model.UpdateTrialComponentRequest.ReadOnly {
    override val trialComponentName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives
        .ExperimentEntityName(impl.trialComponentName())
    override val displayName: Option[ExperimentEntityName] = scala
      .Option(impl.displayName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
      )
    override val status
        : Option[zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly] = scala
      .Option(impl.status())
      .map(value => zio.aws.sagemaker.model.TrialComponentStatus.wrap(value))
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val parameters: Option[Map[
      TrialComponentKey256,
      zio.aws.sagemaker.model.TrialComponentParameterValue.ReadOnly
    ]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.TrialComponentKey256(
              key
            ) -> zio.aws.sagemaker.model.TrialComponentParameterValue
              .wrap(value)
          })
          .toMap
      )
    override val parametersToRemove: Option[List[TrialComponentKey256]] = scala
      .Option(impl.parametersToRemove())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.TrialComponentKey256(item)
        }.toList
      )
    override val inputArtifacts: Option[Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]] = scala
      .Option(impl.inputArtifacts())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.TrialComponentKey64(
              key
            ) -> zio.aws.sagemaker.model.TrialComponentArtifact.wrap(value)
          })
          .toMap
      )
    override val inputArtifactsToRemove: Option[List[TrialComponentKey256]] =
      scala
        .Option(impl.inputArtifactsToRemove())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.TrialComponentKey256(item)
          }.toList
        )
    override val outputArtifacts: Option[Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]] = scala
      .Option(impl.outputArtifacts())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.TrialComponentKey64(
              key
            ) -> zio.aws.sagemaker.model.TrialComponentArtifact.wrap(value)
          })
          .toMap
      )
    override val outputArtifactsToRemove: Option[List[TrialComponentKey256]] =
      scala
        .Option(impl.outputArtifactsToRemove())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.TrialComponentKey256(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentRequest
  ): zio.aws.sagemaker.model.UpdateTrialComponentRequest.ReadOnly = new Wrapper(
    impl
  )
}
