package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  CustomerMetadataValue,
  CustomerMetadataKey,
  ApprovalDescription,
  ModelPackageArn
}
import scala.jdk.CollectionConverters.*
final case class UpdateModelPackageRequest(
    modelPackageArn: ModelPackageArn,
    modelApprovalStatus: Option[zio.aws.sagemaker.model.ModelApprovalStatus] =
      None,
    approvalDescription: Option[ApprovalDescription] = None,
    customerMetadataProperties: Option[
      Map[CustomerMetadataKey, CustomerMetadataValue]
    ] = None,
    customerMetadataPropertiesToRemove: Option[Iterable[CustomerMetadataKey]] =
      None,
    additionalInferenceSpecificationsToAdd: Option[Iterable[
      zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateModelPackageRequest = {
    import UpdateModelPackageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateModelPackageRequest
      .builder()
      .modelPackageArn(
        ModelPackageArn.unwrap(modelPackageArn): java.lang.String
      )
      .optionallyWith(modelApprovalStatus.map(value => value.unwrap))(
        _.modelApprovalStatus
      )
      .optionallyWith(
        approvalDescription.map(value =>
          ApprovalDescription.unwrap(value): java.lang.String
        )
      )(_.approvalDescription)
      .optionallyWith(
        customerMetadataProperties.map(value =>
          value
            .map({ case (key, value) =>
              (CustomerMetadataKey.unwrap(
                key
              ): java.lang.String) -> (CustomerMetadataValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.customerMetadataProperties)
      .optionallyWith(
        customerMetadataPropertiesToRemove.map(value =>
          value.map { item =>
            CustomerMetadataKey.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.customerMetadataPropertiesToRemove)
      .optionallyWith(
        additionalInferenceSpecificationsToAdd.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalInferenceSpecificationsToAdd)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateModelPackageRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateModelPackageRequest.wrap(buildAwsValue())
}
object UpdateModelPackageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateModelPackageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateModelPackageRequest =
      zio.aws.sagemaker.model.UpdateModelPackageRequest(
        modelPackageArn,
        modelApprovalStatus.map(value => value),
        approvalDescription.map(value => value),
        customerMetadataProperties.map(value => value),
        customerMetadataPropertiesToRemove.map(value => value),
        additionalInferenceSpecificationsToAdd.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def modelPackageArn: ModelPackageArn
    def modelApprovalStatus: Option[zio.aws.sagemaker.model.ModelApprovalStatus]
    def approvalDescription: Option[ApprovalDescription]
    def customerMetadataProperties
        : Option[Map[CustomerMetadataKey, CustomerMetadataValue]]
    def customerMetadataPropertiesToRemove: Option[List[CustomerMetadataKey]]
    def additionalInferenceSpecificationsToAdd: Option[List[
      zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition.ReadOnly
    ]]
    def getModelPackageArn: ZIO[Any, Nothing, ModelPackageArn] =
      ZIO.succeed(modelPackageArn)
    def getModelApprovalStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelApprovalStatus] =
      AwsError.unwrapOptionField("modelApprovalStatus", modelApprovalStatus)
    def getApprovalDescription: ZIO[Any, AwsError, ApprovalDescription] =
      AwsError.unwrapOptionField("approvalDescription", approvalDescription)
    def getCustomerMetadataProperties
        : ZIO[Any, AwsError, Map[CustomerMetadataKey, CustomerMetadataValue]] =
      AwsError.unwrapOptionField(
        "customerMetadataProperties",
        customerMetadataProperties
      )
    def getCustomerMetadataPropertiesToRemove
        : ZIO[Any, AwsError, List[CustomerMetadataKey]] =
      AwsError.unwrapOptionField(
        "customerMetadataPropertiesToRemove",
        customerMetadataPropertiesToRemove
      )
    def getAdditionalInferenceSpecificationsToAdd: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "additionalInferenceSpecificationsToAdd",
      additionalInferenceSpecificationsToAdd
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateModelPackageRequest
  ) extends zio.aws.sagemaker.model.UpdateModelPackageRequest.ReadOnly {
    override val modelPackageArn: ModelPackageArn =
      zio.aws.sagemaker.model.primitives.ModelPackageArn(impl.modelPackageArn())
    override val modelApprovalStatus
        : Option[zio.aws.sagemaker.model.ModelApprovalStatus] = scala
      .Option(impl.modelApprovalStatus())
      .map(value => zio.aws.sagemaker.model.ModelApprovalStatus.wrap(value))
    override val approvalDescription: Option[ApprovalDescription] = scala
      .Option(impl.approvalDescription())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ApprovalDescription(value)
      )
    override val customerMetadataProperties
        : Option[Map[CustomerMetadataKey, CustomerMetadataValue]] = scala
      .Option(impl.customerMetadataProperties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.CustomerMetadataKey(
              key
            ) -> zio.aws.sagemaker.model.primitives.CustomerMetadataValue(value)
          })
          .toMap
      )
    override val customerMetadataPropertiesToRemove
        : Option[List[CustomerMetadataKey]] = scala
      .Option(impl.customerMetadataPropertiesToRemove())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.CustomerMetadataKey(item)
        }.toList
      )
    override val additionalInferenceSpecificationsToAdd: Option[List[
      zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition.ReadOnly
    ]] = scala
      .Option(impl.additionalInferenceSpecificationsToAdd())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateModelPackageRequest
  ): zio.aws.sagemaker.model.UpdateModelPackageRequest.ReadOnly = new Wrapper(
    impl
  )
}
