package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.ExperimentArn
import scala.jdk.CollectionConverters.*
final case class UpdateExperimentResponse(
    experimentArn: Option[ExperimentArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateExperimentResponse = {
    import UpdateExperimentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateExperimentResponse
      .builder()
      .optionallyWith(
        experimentArn.map(value =>
          ExperimentArn.unwrap(value): java.lang.String
        )
      )(_.experimentArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateExperimentResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdateExperimentResponse.wrap(buildAwsValue())
}
object UpdateExperimentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateExperimentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateExperimentResponse =
      zio.aws.sagemaker.model
        .UpdateExperimentResponse(experimentArn.map(value => value))
    def experimentArn: Option[ExperimentArn]
    def getExperimentArn: ZIO[Any, AwsError, ExperimentArn] =
      AwsError.unwrapOptionField("experimentArn", experimentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateExperimentResponse
  ) extends zio.aws.sagemaker.model.UpdateExperimentResponse.ReadOnly {
    override val experimentArn: Option[ExperimentArn] = scala
      .Option(impl.experimentArn())
      .map(value => zio.aws.sagemaker.model.primitives.ExperimentArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateExperimentResponse
  ): zio.aws.sagemaker.model.UpdateExperimentResponse.ReadOnly = new Wrapper(
    impl
  )
}
