package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  TrialComponentArn,
  ExperimentEntityName
}
import scala.jdk.CollectionConverters.*
final case class TrialComponentSummary(
    trialComponentName: Option[ExperimentEntityName] = None,
    trialComponentArn: Option[TrialComponentArn] = None,
    displayName: Option[ExperimentEntityName] = None,
    trialComponentSource: Option[zio.aws.sagemaker.model.TrialComponentSource] =
      None,
    status: Option[zio.aws.sagemaker.model.TrialComponentStatus] = None,
    startTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None,
    creationTime: Option[Timestamp] = None,
    createdBy: Option[zio.aws.sagemaker.model.UserContext] = None,
    lastModifiedTime: Option[Timestamp] = None,
    lastModifiedBy: Option[zio.aws.sagemaker.model.UserContext] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrialComponentSummary = {
    import TrialComponentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrialComponentSummary
      .builder()
      .optionallyWith(
        trialComponentName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.trialComponentName)
      .optionallyWith(
        trialComponentArn.map(value =>
          TrialComponentArn.unwrap(value): java.lang.String
        )
      )(_.trialComponentArn)
      .optionallyWith(
        displayName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(trialComponentSource.map(value => value.buildAwsValue()))(
        _.trialComponentSource
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrialComponentSummary.ReadOnly =
    zio.aws.sagemaker.model.TrialComponentSummary.wrap(buildAwsValue())
}
object TrialComponentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrialComponentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrialComponentSummary =
      zio.aws.sagemaker.model.TrialComponentSummary(
        trialComponentName.map(value => value),
        trialComponentArn.map(value => value),
        displayName.map(value => value),
        trialComponentSource.map(value => value.asEditable),
        status.map(value => value.asEditable),
        startTime.map(value => value),
        endTime.map(value => value),
        creationTime.map(value => value),
        createdBy.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        lastModifiedBy.map(value => value.asEditable)
      )
    def trialComponentName: Option[ExperimentEntityName]
    def trialComponentArn: Option[TrialComponentArn]
    def displayName: Option[ExperimentEntityName]
    def trialComponentSource
        : Option[zio.aws.sagemaker.model.TrialComponentSource.ReadOnly]
    def status: Option[zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly]
    def startTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def creationTime: Option[Timestamp]
    def createdBy: Option[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def lastModifiedTime: Option[Timestamp]
    def lastModifiedBy: Option[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def getTrialComponentName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("trialComponentName", trialComponentName)
    def getTrialComponentArn: ZIO[Any, AwsError, TrialComponentArn] =
      AwsError.unwrapOptionField("trialComponentArn", trialComponentArn)
    def getDisplayName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getTrialComponentSource: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TrialComponentSource.ReadOnly
    ] = AwsError.unwrapOptionField("trialComponentSource", trialComponentSource)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponentSummary
  ) extends zio.aws.sagemaker.model.TrialComponentSummary.ReadOnly {
    override val trialComponentName: Option[ExperimentEntityName] = scala
      .Option(impl.trialComponentName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
      )
    override val trialComponentArn: Option[TrialComponentArn] = scala
      .Option(impl.trialComponentArn())
      .map(value => zio.aws.sagemaker.model.primitives.TrialComponentArn(value))
    override val displayName: Option[ExperimentEntityName] = scala
      .Option(impl.displayName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
      )
    override val trialComponentSource
        : Option[zio.aws.sagemaker.model.TrialComponentSource.ReadOnly] = scala
      .Option(impl.trialComponentSource())
      .map(value => zio.aws.sagemaker.model.TrialComponentSource.wrap(value))
    override val status
        : Option[zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly] = scala
      .Option(impl.status())
      .map(value => zio.aws.sagemaker.model.TrialComponentStatus.wrap(value))
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBy
        : Option[zio.aws.sagemaker.model.UserContext.ReadOnly] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedBy
        : Option[zio.aws.sagemaker.model.UserContext.ReadOnly] = scala
      .Option(impl.lastModifiedBy())
      .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponentSummary
  ): zio.aws.sagemaker.model.TrialComponentSummary.ReadOnly = new Wrapper(impl)
}
