package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.TrainingJobArn
import scala.jdk.CollectionConverters.*
final case class TrainingJobStepMetadata(arn: Option[TrainingJobArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrainingJobStepMetadata = {
    import TrainingJobStepMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrainingJobStepMetadata
      .builder()
      .optionallyWith(
        arn.map(value => TrainingJobArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrainingJobStepMetadata.ReadOnly =
    zio.aws.sagemaker.model.TrainingJobStepMetadata.wrap(buildAwsValue())
}
object TrainingJobStepMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrainingJobStepMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrainingJobStepMetadata =
      zio.aws.sagemaker.model.TrainingJobStepMetadata(arn.map(value => value))
    def arn: Option[TrainingJobArn]
    def getArn: ZIO[Any, AwsError, TrainingJobArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrainingJobStepMetadata
  ) extends zio.aws.sagemaker.model.TrainingJobStepMetadata.ReadOnly {
    override val arn: Option[TrainingJobArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.sagemaker.model.primitives.TrainingJobArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrainingJobStepMetadata
  ): zio.aws.sagemaker.model.TrainingJobStepMetadata.ReadOnly = new Wrapper(
    impl
  )
}
