package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.ServiceCatalogEntityId
import scala.jdk.CollectionConverters.*
final case class ServiceCatalogProvisioningUpdateDetails(
    provisioningArtifactId: Option[ServiceCatalogEntityId] = None,
    provisioningParameters: Option[
      Iterable[zio.aws.sagemaker.model.ProvisioningParameter]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ServiceCatalogProvisioningUpdateDetails = {
    import ServiceCatalogProvisioningUpdateDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ServiceCatalogProvisioningUpdateDetails
      .builder()
      .optionallyWith(
        provisioningArtifactId.map(value =>
          ServiceCatalogEntityId.unwrap(value): java.lang.String
        )
      )(_.provisioningArtifactId)
      .optionallyWith(
        provisioningParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisioningParameters)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ServiceCatalogProvisioningUpdateDetails.ReadOnly =
    zio.aws.sagemaker.model.ServiceCatalogProvisioningUpdateDetails
      .wrap(buildAwsValue())
}
object ServiceCatalogProvisioningUpdateDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ServiceCatalogProvisioningUpdateDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.ServiceCatalogProvisioningUpdateDetails =
      zio.aws.sagemaker.model.ServiceCatalogProvisioningUpdateDetails(
        provisioningArtifactId.map(value => value),
        provisioningParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def provisioningArtifactId: Option[ServiceCatalogEntityId]
    def provisioningParameters
        : Option[List[zio.aws.sagemaker.model.ProvisioningParameter.ReadOnly]]
    def getProvisioningArtifactId: ZIO[Any, AwsError, ServiceCatalogEntityId] =
      AwsError.unwrapOptionField(
        "provisioningArtifactId",
        provisioningArtifactId
      )
    def getProvisioningParameters: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ProvisioningParameter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "provisioningParameters",
      provisioningParameters
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ServiceCatalogProvisioningUpdateDetails
  ) extends zio.aws.sagemaker.model.ServiceCatalogProvisioningUpdateDetails.ReadOnly {
    override val provisioningArtifactId: Option[ServiceCatalogEntityId] = scala
      .Option(impl.provisioningArtifactId())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ServiceCatalogEntityId(value)
      )
    override val provisioningParameters
        : Option[List[zio.aws.sagemaker.model.ProvisioningParameter.ReadOnly]] =
      scala
        .Option(impl.provisioningParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.ProvisioningParameter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ServiceCatalogProvisioningUpdateDetails
  ): zio.aws.sagemaker.model.ServiceCatalogProvisioningUpdateDetails.ReadOnly =
    new Wrapper(impl)
}
