package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  StudioLifecycleConfigArn,
  ImageVersionArn,
  ImageArn
}
import scala.jdk.CollectionConverters.*
final case class ResourceSpec(
    sageMakerImageArn: Option[ImageArn] = None,
    sageMakerImageVersionArn: Option[ImageVersionArn] = None,
    instanceType: Option[zio.aws.sagemaker.model.AppInstanceType] = None,
    lifecycleConfigArn: Option[StudioLifecycleConfigArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ResourceSpec = {
    import ResourceSpec.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ResourceSpec
      .builder()
      .optionallyWith(
        sageMakerImageArn.map(value => ImageArn.unwrap(value): java.lang.String)
      )(_.sageMakerImageArn)
      .optionallyWith(
        sageMakerImageVersionArn.map(value =>
          ImageVersionArn.unwrap(value): java.lang.String
        )
      )(_.sageMakerImageVersionArn)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        lifecycleConfigArn.map(value =>
          StudioLifecycleConfigArn.unwrap(value): java.lang.String
        )
      )(_.lifecycleConfigArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ResourceSpec.ReadOnly =
    zio.aws.sagemaker.model.ResourceSpec.wrap(buildAwsValue())
}
object ResourceSpec {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ResourceSpec
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ResourceSpec =
      zio.aws.sagemaker.model.ResourceSpec(
        sageMakerImageArn.map(value => value),
        sageMakerImageVersionArn.map(value => value),
        instanceType.map(value => value),
        lifecycleConfigArn.map(value => value)
      )
    def sageMakerImageArn: Option[ImageArn]
    def sageMakerImageVersionArn: Option[ImageVersionArn]
    def instanceType: Option[zio.aws.sagemaker.model.AppInstanceType]
    def lifecycleConfigArn: Option[StudioLifecycleConfigArn]
    def getSageMakerImageArn: ZIO[Any, AwsError, ImageArn] =
      AwsError.unwrapOptionField("sageMakerImageArn", sageMakerImageArn)
    def getSageMakerImageVersionArn: ZIO[Any, AwsError, ImageVersionArn] =
      AwsError.unwrapOptionField(
        "sageMakerImageVersionArn",
        sageMakerImageVersionArn
      )
    def getInstanceType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AppInstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getLifecycleConfigArn: ZIO[Any, AwsError, StudioLifecycleConfigArn] =
      AwsError.unwrapOptionField("lifecycleConfigArn", lifecycleConfigArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ResourceSpec
  ) extends zio.aws.sagemaker.model.ResourceSpec.ReadOnly {
    override val sageMakerImageArn: Option[ImageArn] = scala
      .Option(impl.sageMakerImageArn())
      .map(value => zio.aws.sagemaker.model.primitives.ImageArn(value))
    override val sageMakerImageVersionArn: Option[ImageVersionArn] = scala
      .Option(impl.sageMakerImageVersionArn())
      .map(value => zio.aws.sagemaker.model.primitives.ImageVersionArn(value))
    override val instanceType: Option[zio.aws.sagemaker.model.AppInstanceType] =
      scala
        .Option(impl.instanceType())
        .map(value => zio.aws.sagemaker.model.AppInstanceType.wrap(value))
    override val lifecycleConfigArn: Option[StudioLifecycleConfigArn] = scala
      .Option(impl.lifecycleConfigArn())
      .map(value =>
        zio.aws.sagemaker.model.primitives.StudioLifecycleConfigArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ResourceSpec
  ): zio.aws.sagemaker.model.ResourceSpec.ReadOnly = new Wrapper(impl)
}
