package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResolvedAttributes(
    autoMLJobObjective: Option[zio.aws.sagemaker.model.AutoMLJobObjective] =
      None,
    problemType: Option[zio.aws.sagemaker.model.ProblemType] = None,
    completionCriteria: Option[
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ResolvedAttributes = {
    import ResolvedAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ResolvedAttributes
      .builder()
      .optionallyWith(autoMLJobObjective.map(value => value.buildAwsValue()))(
        _.autoMLJobObjective
      )
      .optionallyWith(problemType.map(value => value.unwrap))(_.problemType)
      .optionallyWith(completionCriteria.map(value => value.buildAwsValue()))(
        _.completionCriteria
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ResolvedAttributes.ReadOnly =
    zio.aws.sagemaker.model.ResolvedAttributes.wrap(buildAwsValue())
}
object ResolvedAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ResolvedAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ResolvedAttributes =
      zio.aws.sagemaker.model.ResolvedAttributes(
        autoMLJobObjective.map(value => value.asEditable),
        problemType.map(value => value),
        completionCriteria.map(value => value.asEditable)
      )
    def autoMLJobObjective
        : Option[zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly]
    def problemType: Option[zio.aws.sagemaker.model.ProblemType]
    def completionCriteria
        : Option[zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly]
    def getAutoMLJobObjective: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly
    ] = AwsError.unwrapOptionField("autoMLJobObjective", autoMLJobObjective)
    def getProblemType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ProblemType] =
      AwsError.unwrapOptionField("problemType", problemType)
    def getCompletionCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("completionCriteria", completionCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ResolvedAttributes
  ) extends zio.aws.sagemaker.model.ResolvedAttributes.ReadOnly {
    override val autoMLJobObjective
        : Option[zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly] = scala
      .Option(impl.autoMLJobObjective())
      .map(value => zio.aws.sagemaker.model.AutoMLJobObjective.wrap(value))
    override val problemType: Option[zio.aws.sagemaker.model.ProblemType] =
      scala
        .Option(impl.problemType())
        .map(value => zio.aws.sagemaker.model.ProblemType.wrap(value))
    override val completionCriteria
        : Option[zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly] =
      scala
        .Option(impl.completionCriteria())
        .map(value =>
          zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ResolvedAttributes
  ): zio.aws.sagemaker.model.ResolvedAttributes.ReadOnly = new Wrapper(impl)
}
