package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.BlockedReason
import scala.jdk.CollectionConverters.*
final case class OfflineStoreStatus(
    status: zio.aws.sagemaker.model.OfflineStoreStatusValue,
    blockedReason: Option[BlockedReason] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.OfflineStoreStatus = {
    import OfflineStoreStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.OfflineStoreStatus
      .builder()
      .status(status.unwrap)
      .optionallyWith(
        blockedReason.map(value =>
          BlockedReason.unwrap(value): java.lang.String
        )
      )(_.blockedReason)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.OfflineStoreStatus.ReadOnly =
    zio.aws.sagemaker.model.OfflineStoreStatus.wrap(buildAwsValue())
}
object OfflineStoreStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.OfflineStoreStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.OfflineStoreStatus =
      zio.aws.sagemaker.model
        .OfflineStoreStatus(status, blockedReason.map(value => value))
    def status: zio.aws.sagemaker.model.OfflineStoreStatusValue
    def blockedReason: Option[BlockedReason]
    def getStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.OfflineStoreStatusValue] =
      ZIO.succeed(status)
    def getBlockedReason: ZIO[Any, AwsError, BlockedReason] =
      AwsError.unwrapOptionField("blockedReason", blockedReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.OfflineStoreStatus
  ) extends zio.aws.sagemaker.model.OfflineStoreStatus.ReadOnly {
    override val status: zio.aws.sagemaker.model.OfflineStoreStatusValue =
      zio.aws.sagemaker.model.OfflineStoreStatusValue.wrap(impl.status())
    override val blockedReason: Option[BlockedReason] = scala
      .Option(impl.blockedReason())
      .map(value => zio.aws.sagemaker.model.primitives.BlockedReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.OfflineStoreStatus
  ): zio.aws.sagemaker.model.OfflineStoreStatus.ReadOnly = new Wrapper(impl)
}
