package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListWorkforcesResponse(
    workforces: Iterable[zio.aws.sagemaker.model.Workforce],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListWorkforcesResponse = {
    import ListWorkforcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListWorkforcesResponse
      .builder()
      .workforces(workforces.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListWorkforcesResponse.ReadOnly =
    zio.aws.sagemaker.model.ListWorkforcesResponse.wrap(buildAwsValue())
}
object ListWorkforcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListWorkforcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListWorkforcesResponse =
      zio.aws.sagemaker.model.ListWorkforcesResponse(
        workforces.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def workforces: List[zio.aws.sagemaker.model.Workforce.ReadOnly]
    def nextToken: Option[NextToken]
    def getWorkforces
        : ZIO[Any, Nothing, List[zio.aws.sagemaker.model.Workforce.ReadOnly]] =
      ZIO.succeed(workforces)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListWorkforcesResponse
  ) extends zio.aws.sagemaker.model.ListWorkforcesResponse.ReadOnly {
    override val workforces: List[zio.aws.sagemaker.model.Workforce.ReadOnly] =
      impl
        .workforces()
        .asScala
        .map { item =>
          zio.aws.sagemaker.model.Workforce.wrap(item)
        }
        .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListWorkforcesResponse
  ): zio.aws.sagemaker.model.ListWorkforcesResponse.ReadOnly = new Wrapper(impl)
}
