package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListModelsResponse(
    models: Iterable[zio.aws.sagemaker.model.ModelSummary],
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListModelsResponse = {
    import ListModelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListModelsResponse
      .builder()
      .models(models.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListModelsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListModelsResponse.wrap(buildAwsValue())
}
object ListModelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListModelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListModelsResponse =
      zio.aws.sagemaker.model.ListModelsResponse(
        models.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def models: List[zio.aws.sagemaker.model.ModelSummary.ReadOnly]
    def nextToken: Option[PaginationToken]
    def getModels: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.ModelSummary.ReadOnly
    ]] = ZIO.succeed(models)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelsResponse
  ) extends zio.aws.sagemaker.model.ListModelsResponse.ReadOnly {
    override val models: List[zio.aws.sagemaker.model.ModelSummary.ReadOnly] =
      impl
        .models()
        .asScala
        .map { item =>
          zio.aws.sagemaker.model.ModelSummary.wrap(item)
        }
        .toList
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelsResponse
  ): zio.aws.sagemaker.model.ListModelsResponse.ReadOnly = new Wrapper(impl)
}
