package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListModelPackageGroupsResponse(
    modelPackageGroupSummaryList: Iterable[
      zio.aws.sagemaker.model.ModelPackageGroupSummary
    ],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsResponse = {
    import ListModelPackageGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsResponse
      .builder()
      .modelPackageGroupSummaryList(modelPackageGroupSummaryList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListModelPackageGroupsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListModelPackageGroupsResponse.wrap(buildAwsValue())
}
object ListModelPackageGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListModelPackageGroupsResponse =
      zio.aws.sagemaker.model.ListModelPackageGroupsResponse(
        modelPackageGroupSummaryList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def modelPackageGroupSummaryList
        : List[zio.aws.sagemaker.model.ModelPackageGroupSummary.ReadOnly]
    def nextToken: Option[NextToken]
    def getModelPackageGroupSummaryList: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.ModelPackageGroupSummary.ReadOnly
    ]] = ZIO.succeed(modelPackageGroupSummaryList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsResponse
  ) extends zio.aws.sagemaker.model.ListModelPackageGroupsResponse.ReadOnly {
    override val modelPackageGroupSummaryList
        : List[zio.aws.sagemaker.model.ModelPackageGroupSummary.ReadOnly] = impl
      .modelPackageGroupSummaryList()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.ModelPackageGroupSummary.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsResponse
  ): zio.aws.sagemaker.model.ListModelPackageGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
