package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  ImageNameContains,
  MaxResults,
  Timestamp
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListImagesRequest(
    creationTimeAfter: Option[Timestamp] = None,
    creationTimeBefore: Option[Timestamp] = None,
    lastModifiedTimeAfter: Option[Timestamp] = None,
    lastModifiedTimeBefore: Option[Timestamp] = None,
    maxResults: Option[MaxResults] = None,
    nameContains: Option[ImageNameContains] = None,
    nextToken: Option[NextToken] = None,
    sortBy: Option[zio.aws.sagemaker.model.ImageSortBy] = None,
    sortOrder: Option[zio.aws.sagemaker.model.ImageSortOrder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListImagesRequest = {
    import ListImagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListImagesRequest
      .builder()
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        lastModifiedTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTimeAfter)
      .optionallyWith(
        lastModifiedTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTimeBefore)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nameContains.map(value =>
          ImageNameContains.unwrap(value): java.lang.String
        )
      )(_.nameContains)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListImagesRequest.ReadOnly =
    zio.aws.sagemaker.model.ListImagesRequest.wrap(buildAwsValue())
}
object ListImagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListImagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListImagesRequest =
      zio.aws.sagemaker.model.ListImagesRequest(
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        lastModifiedTimeAfter.map(value => value),
        lastModifiedTimeBefore.map(value => value),
        maxResults.map(value => value),
        nameContains.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def creationTimeAfter: Option[Timestamp]
    def creationTimeBefore: Option[Timestamp]
    def lastModifiedTimeAfter: Option[Timestamp]
    def lastModifiedTimeBefore: Option[Timestamp]
    def maxResults: Option[MaxResults]
    def nameContains: Option[ImageNameContains]
    def nextToken: Option[NextToken]
    def sortBy: Option[zio.aws.sagemaker.model.ImageSortBy]
    def sortOrder: Option[zio.aws.sagemaker.model.ImageSortOrder]
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getLastModifiedTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTimeAfter", lastModifiedTimeAfter)
    def getLastModifiedTimeBefore: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastModifiedTimeBefore", lastModifiedTimeBefore)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNameContains: ZIO[Any, AwsError, ImageNameContains] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy: ZIO[Any, AwsError, zio.aws.sagemaker.model.ImageSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ImageSortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListImagesRequest
  ) extends zio.aws.sagemaker.model.ListImagesRequest.ReadOnly {
    override val creationTimeAfter: Option[Timestamp] = scala
      .Option(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeBefore: Option[Timestamp] = scala
      .Option(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTimeAfter: Option[Timestamp] = scala
      .Option(impl.lastModifiedTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTimeBefore: Option[Timestamp] = scala
      .Option(impl.lastModifiedTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val nameContains: Option[ImageNameContains] = scala
      .Option(impl.nameContains())
      .map(value => zio.aws.sagemaker.model.primitives.ImageNameContains(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val sortBy: Option[zio.aws.sagemaker.model.ImageSortBy] = scala
      .Option(impl.sortBy())
      .map(value => zio.aws.sagemaker.model.ImageSortBy.wrap(value))
    override val sortOrder: Option[zio.aws.sagemaker.model.ImageSortOrder] =
      scala
        .Option(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.ImageSortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListImagesRequest
  ): zio.aws.sagemaker.model.ListImagesRequest.ReadOnly = new Wrapper(impl)
}
