package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{MaxResults, NextToken, Timestamp}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListHumanTaskUisRequest(
    creationTimeAfter: Option[Timestamp] = None,
    creationTimeBefore: Option[Timestamp] = None,
    sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisRequest = {
    import ListHumanTaskUisRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisRequest
      .builder()
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListHumanTaskUisRequest.ReadOnly =
    zio.aws.sagemaker.model.ListHumanTaskUisRequest.wrap(buildAwsValue())
}
object ListHumanTaskUisRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListHumanTaskUisRequest =
      zio.aws.sagemaker.model.ListHumanTaskUisRequest(
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def creationTimeAfter: Option[Timestamp]
    def creationTimeBefore: Option[Timestamp]
    def sortOrder: Option[zio.aws.sagemaker.model.SortOrder]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisRequest
  ) extends zio.aws.sagemaker.model.ListHumanTaskUisRequest.ReadOnly {
    override val creationTimeAfter: Option[Timestamp] = scala
      .Option(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeBefore: Option[Timestamp] = scala
      .Option(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisRequest
  ): zio.aws.sagemaker.model.ListHumanTaskUisRequest.ReadOnly = new Wrapper(
    impl
  )
}
