package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  FeatureGroupMaxResults,
  CreationTime,
  FeatureGroupNameContains
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListFeatureGroupsRequest(
    nameContains: Option[FeatureGroupNameContains] = None,
    featureGroupStatusEquals: Option[
      zio.aws.sagemaker.model.FeatureGroupStatus
    ] = None,
    offlineStoreStatusEquals: Option[
      zio.aws.sagemaker.model.OfflineStoreStatusValue
    ] = None,
    creationTimeAfter: Option[CreationTime] = None,
    creationTimeBefore: Option[CreationTime] = None,
    sortOrder: Option[zio.aws.sagemaker.model.FeatureGroupSortOrder] = None,
    sortBy: Option[zio.aws.sagemaker.model.FeatureGroupSortBy] = None,
    maxResults: Option[FeatureGroupMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsRequest = {
    import ListFeatureGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsRequest
      .builder()
      .optionallyWith(
        nameContains.map(value =>
          FeatureGroupNameContains.unwrap(value): java.lang.String
        )
      )(_.nameContains)
      .optionallyWith(featureGroupStatusEquals.map(value => value.unwrap))(
        _.featureGroupStatusEquals
      )
      .optionallyWith(offlineStoreStatusEquals.map(value => value.unwrap))(
        _.offlineStoreStatusEquals
      )
      .optionallyWith(
        creationTimeAfter.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(
        maxResults.map(value => FeatureGroupMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListFeatureGroupsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListFeatureGroupsRequest.wrap(buildAwsValue())
}
object ListFeatureGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListFeatureGroupsRequest =
      zio.aws.sagemaker.model.ListFeatureGroupsRequest(
        nameContains.map(value => value),
        featureGroupStatusEquals.map(value => value),
        offlineStoreStatusEquals.map(value => value),
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        sortOrder.map(value => value),
        sortBy.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def nameContains: Option[FeatureGroupNameContains]
    def featureGroupStatusEquals
        : Option[zio.aws.sagemaker.model.FeatureGroupStatus]
    def offlineStoreStatusEquals
        : Option[zio.aws.sagemaker.model.OfflineStoreStatusValue]
    def creationTimeAfter: Option[CreationTime]
    def creationTimeBefore: Option[CreationTime]
    def sortOrder: Option[zio.aws.sagemaker.model.FeatureGroupSortOrder]
    def sortBy: Option[zio.aws.sagemaker.model.FeatureGroupSortBy]
    def maxResults: Option[FeatureGroupMaxResults]
    def nextToken: Option[NextToken]
    def getNameContains: ZIO[Any, AwsError, FeatureGroupNameContains] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getFeatureGroupStatusEquals
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.FeatureGroupStatus] =
      AwsError.unwrapOptionField(
        "featureGroupStatusEquals",
        featureGroupStatusEquals
      )
    def getOfflineStoreStatusEquals
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.OfflineStoreStatusValue] =
      AwsError.unwrapOptionField(
        "offlineStoreStatusEquals",
        offlineStoreStatusEquals
      )
    def getCreationTimeAfter: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.FeatureGroupSortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.FeatureGroupSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getMaxResults: ZIO[Any, AwsError, FeatureGroupMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsRequest
  ) extends zio.aws.sagemaker.model.ListFeatureGroupsRequest.ReadOnly {
    override val nameContains: Option[FeatureGroupNameContains] = scala
      .Option(impl.nameContains())
      .map(value =>
        zio.aws.sagemaker.model.primitives.FeatureGroupNameContains(value)
      )
    override val featureGroupStatusEquals
        : Option[zio.aws.sagemaker.model.FeatureGroupStatus] = scala
      .Option(impl.featureGroupStatusEquals())
      .map(value => zio.aws.sagemaker.model.FeatureGroupStatus.wrap(value))
    override val offlineStoreStatusEquals
        : Option[zio.aws.sagemaker.model.OfflineStoreStatusValue] = scala
      .Option(impl.offlineStoreStatusEquals())
      .map(value => zio.aws.sagemaker.model.OfflineStoreStatusValue.wrap(value))
    override val creationTimeAfter: Option[CreationTime] = scala
      .Option(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val creationTimeBefore: Option[CreationTime] = scala
      .Option(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val sortOrder
        : Option[zio.aws.sagemaker.model.FeatureGroupSortOrder] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.sagemaker.model.FeatureGroupSortOrder.wrap(value))
    override val sortBy: Option[zio.aws.sagemaker.model.FeatureGroupSortBy] =
      scala
        .Option(impl.sortBy())
        .map(value => zio.aws.sagemaker.model.FeatureGroupSortBy.wrap(value))
    override val maxResults: Option[FeatureGroupMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.sagemaker.model.primitives.FeatureGroupMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsRequest
  ): zio.aws.sagemaker.model.ListFeatureGroupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
