package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{ResponseMIMEType, ContentType}
import scala.jdk.CollectionConverters.*
final case class InferenceSpecification(
    containers: Iterable[
      zio.aws.sagemaker.model.ModelPackageContainerDefinition
    ],
    supportedTransformInstanceTypes: Option[
      Iterable[zio.aws.sagemaker.model.TransformInstanceType]
    ] = None,
    supportedRealtimeInferenceInstanceTypes: Option[
      Iterable[zio.aws.sagemaker.model.ProductionVariantInstanceType]
    ] = None,
    supportedContentTypes: Iterable[ContentType],
    supportedResponseMIMETypes: Iterable[ResponseMIMEType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.InferenceSpecification = {
    import InferenceSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.InferenceSpecification
      .builder()
      .containers(containers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        supportedTransformInstanceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedTransformInstanceTypesWithStrings)
      .optionallyWith(
        supportedRealtimeInferenceInstanceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedRealtimeInferenceInstanceTypesWithStrings)
      .supportedContentTypes(supportedContentTypes.map { item =>
        ContentType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .supportedResponseMIMETypes(supportedResponseMIMETypes.map { item =>
        ResponseMIMEType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.InferenceSpecification.ReadOnly =
    zio.aws.sagemaker.model.InferenceSpecification.wrap(buildAwsValue())
}
object InferenceSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.InferenceSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.InferenceSpecification =
      zio.aws.sagemaker.model.InferenceSpecification(
        containers.map { item =>
          item.asEditable
        },
        supportedTransformInstanceTypes.map(value => value),
        supportedRealtimeInferenceInstanceTypes.map(value => value),
        supportedContentTypes,
        supportedResponseMIMETypes
      )
    def containers
        : List[zio.aws.sagemaker.model.ModelPackageContainerDefinition.ReadOnly]
    def supportedTransformInstanceTypes
        : Option[List[zio.aws.sagemaker.model.TransformInstanceType]]
    def supportedRealtimeInferenceInstanceTypes
        : Option[List[zio.aws.sagemaker.model.ProductionVariantInstanceType]]
    def supportedContentTypes: List[ContentType]
    def supportedResponseMIMETypes: List[ResponseMIMEType]
    def getContainers: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.ModelPackageContainerDefinition.ReadOnly
    ]] = ZIO.succeed(containers)
    def getSupportedTransformInstanceTypes: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.TransformInstanceType
    ]] = AwsError.unwrapOptionField(
      "supportedTransformInstanceTypes",
      supportedTransformInstanceTypes
    )
    def getSupportedRealtimeInferenceInstanceTypes: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ProductionVariantInstanceType
    ]] = AwsError.unwrapOptionField(
      "supportedRealtimeInferenceInstanceTypes",
      supportedRealtimeInferenceInstanceTypes
    )
    def getSupportedContentTypes: ZIO[Any, Nothing, List[ContentType]] =
      ZIO.succeed(supportedContentTypes)
    def getSupportedResponseMIMETypes
        : ZIO[Any, Nothing, List[ResponseMIMEType]] =
      ZIO.succeed(supportedResponseMIMETypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.InferenceSpecification
  ) extends zio.aws.sagemaker.model.InferenceSpecification.ReadOnly {
    override val containers: List[
      zio.aws.sagemaker.model.ModelPackageContainerDefinition.ReadOnly
    ] = impl
      .containers()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.ModelPackageContainerDefinition.wrap(item)
      }
      .toList
    override val supportedTransformInstanceTypes
        : Option[List[zio.aws.sagemaker.model.TransformInstanceType]] = scala
      .Option(impl.supportedTransformInstanceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.TransformInstanceType.wrap(item)
        }.toList
      )
    override val supportedRealtimeInferenceInstanceTypes
        : Option[List[zio.aws.sagemaker.model.ProductionVariantInstanceType]] =
      scala
        .Option(impl.supportedRealtimeInferenceInstanceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.ProductionVariantInstanceType.wrap(item)
          }.toList
        )
    override val supportedContentTypes: List[ContentType] = impl
      .supportedContentTypes()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.primitives.ContentType(item)
      }
      .toList
    override val supportedResponseMIMETypes: List[ResponseMIMEType] = impl
      .supportedResponseMIMETypes()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.primitives.ResponseMIMEType(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.InferenceSpecification
  ): zio.aws.sagemaker.model.InferenceSpecification.ReadOnly = new Wrapper(impl)
}
