package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  HyperParameterTuningJobArn,
  HyperParameterTuningJobName
}
import scala.jdk.CollectionConverters.*
final case class HyperParameterTuningJobSummary(
    hyperParameterTuningJobName: HyperParameterTuningJobName,
    hyperParameterTuningJobArn: HyperParameterTuningJobArn,
    hyperParameterTuningJobStatus: zio.aws.sagemaker.model.HyperParameterTuningJobStatus,
    strategy: zio.aws.sagemaker.model.HyperParameterTuningJobStrategyType,
    creationTime: Timestamp,
    hyperParameterTuningEndTime: Option[Timestamp] = None,
    lastModifiedTime: Option[Timestamp] = None,
    trainingJobStatusCounters: zio.aws.sagemaker.model.TrainingJobStatusCounters,
    objectiveStatusCounters: zio.aws.sagemaker.model.ObjectiveStatusCounters,
    resourceLimits: Option[zio.aws.sagemaker.model.ResourceLimits] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobSummary = {
    import HyperParameterTuningJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobSummary
      .builder()
      .hyperParameterTuningJobName(
        HyperParameterTuningJobName.unwrap(
          hyperParameterTuningJobName
        ): java.lang.String
      )
      .hyperParameterTuningJobArn(
        HyperParameterTuningJobArn.unwrap(
          hyperParameterTuningJobArn
        ): java.lang.String
      )
      .hyperParameterTuningJobStatus(hyperParameterTuningJobStatus.unwrap)
      .strategy(strategy.unwrap)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(
        hyperParameterTuningEndTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.hyperParameterTuningEndTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .trainingJobStatusCounters(trainingJobStatusCounters.buildAwsValue())
      .objectiveStatusCounters(objectiveStatusCounters.buildAwsValue())
      .optionallyWith(resourceLimits.map(value => value.buildAwsValue()))(
        _.resourceLimits
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.HyperParameterTuningJobSummary.ReadOnly =
    zio.aws.sagemaker.model.HyperParameterTuningJobSummary.wrap(buildAwsValue())
}
object HyperParameterTuningJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.HyperParameterTuningJobSummary =
      zio.aws.sagemaker.model.HyperParameterTuningJobSummary(
        hyperParameterTuningJobName,
        hyperParameterTuningJobArn,
        hyperParameterTuningJobStatus,
        strategy,
        creationTime,
        hyperParameterTuningEndTime.map(value => value),
        lastModifiedTime.map(value => value),
        trainingJobStatusCounters.asEditable,
        objectiveStatusCounters.asEditable,
        resourceLimits.map(value => value.asEditable)
      )
    def hyperParameterTuningJobName: HyperParameterTuningJobName
    def hyperParameterTuningJobArn: HyperParameterTuningJobArn
    def hyperParameterTuningJobStatus
        : zio.aws.sagemaker.model.HyperParameterTuningJobStatus
    def strategy: zio.aws.sagemaker.model.HyperParameterTuningJobStrategyType
    def creationTime: Timestamp
    def hyperParameterTuningEndTime: Option[Timestamp]
    def lastModifiedTime: Option[Timestamp]
    def trainingJobStatusCounters
        : zio.aws.sagemaker.model.TrainingJobStatusCounters.ReadOnly
    def objectiveStatusCounters
        : zio.aws.sagemaker.model.ObjectiveStatusCounters.ReadOnly
    def resourceLimits: Option[zio.aws.sagemaker.model.ResourceLimits.ReadOnly]
    def getHyperParameterTuningJobName
        : ZIO[Any, Nothing, HyperParameterTuningJobName] =
      ZIO.succeed(hyperParameterTuningJobName)
    def getHyperParameterTuningJobArn
        : ZIO[Any, Nothing, HyperParameterTuningJobArn] =
      ZIO.succeed(hyperParameterTuningJobArn)
    def getHyperParameterTuningJobStatus: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.HyperParameterTuningJobStatus
    ] = ZIO.succeed(hyperParameterTuningJobStatus)
    def getStrategy: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.HyperParameterTuningJobStrategyType
    ] = ZIO.succeed(strategy)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getHyperParameterTuningEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "hyperParameterTuningEndTime",
        hyperParameterTuningEndTime
      )
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getTrainingJobStatusCounters: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.TrainingJobStatusCounters.ReadOnly
    ] = ZIO.succeed(trainingJobStatusCounters)
    def getObjectiveStatusCounters: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ObjectiveStatusCounters.ReadOnly
    ] = ZIO.succeed(objectiveStatusCounters)
    def getResourceLimits
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ResourceLimits.ReadOnly] =
      AwsError.unwrapOptionField("resourceLimits", resourceLimits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobSummary
  ) extends zio.aws.sagemaker.model.HyperParameterTuningJobSummary.ReadOnly {
    override val hyperParameterTuningJobName: HyperParameterTuningJobName =
      zio.aws.sagemaker.model.primitives
        .HyperParameterTuningJobName(impl.hyperParameterTuningJobName())
    override val hyperParameterTuningJobArn: HyperParameterTuningJobArn =
      zio.aws.sagemaker.model.primitives
        .HyperParameterTuningJobArn(impl.hyperParameterTuningJobArn())
    override val hyperParameterTuningJobStatus
        : zio.aws.sagemaker.model.HyperParameterTuningJobStatus =
      zio.aws.sagemaker.model.HyperParameterTuningJobStatus
        .wrap(impl.hyperParameterTuningJobStatus())
    override val strategy
        : zio.aws.sagemaker.model.HyperParameterTuningJobStrategyType =
      zio.aws.sagemaker.model.HyperParameterTuningJobStrategyType
        .wrap(impl.strategy())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val hyperParameterTuningEndTime: Option[Timestamp] = scala
      .Option(impl.hyperParameterTuningEndTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val trainingJobStatusCounters
        : zio.aws.sagemaker.model.TrainingJobStatusCounters.ReadOnly =
      zio.aws.sagemaker.model.TrainingJobStatusCounters
        .wrap(impl.trainingJobStatusCounters())
    override val objectiveStatusCounters
        : zio.aws.sagemaker.model.ObjectiveStatusCounters.ReadOnly =
      zio.aws.sagemaker.model.ObjectiveStatusCounters
        .wrap(impl.objectiveStatusCounters())
    override val resourceLimits
        : Option[zio.aws.sagemaker.model.ResourceLimits.ReadOnly] = scala
      .Option(impl.resourceLimits())
      .map(value => zio.aws.sagemaker.model.ResourceLimits.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobSummary
  ): zio.aws.sagemaker.model.HyperParameterTuningJobSummary.ReadOnly =
    new Wrapper(impl)
}
