package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetSearchSuggestionsRequest(
    resource: zio.aws.sagemaker.model.ResourceType,
    suggestionQuery: Option[zio.aws.sagemaker.model.SuggestionQuery] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsRequest = {
    import GetSearchSuggestionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsRequest
      .builder()
      .resource(resource.unwrap)
      .optionallyWith(suggestionQuery.map(value => value.buildAwsValue()))(
        _.suggestionQuery
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.GetSearchSuggestionsRequest.ReadOnly =
    zio.aws.sagemaker.model.GetSearchSuggestionsRequest.wrap(buildAwsValue())
}
object GetSearchSuggestionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.GetSearchSuggestionsRequest =
      zio.aws.sagemaker.model.GetSearchSuggestionsRequest(
        resource,
        suggestionQuery.map(value => value.asEditable)
      )
    def resource: zio.aws.sagemaker.model.ResourceType
    def suggestionQuery
        : Option[zio.aws.sagemaker.model.SuggestionQuery.ReadOnly]
    def getResource: ZIO[Any, Nothing, zio.aws.sagemaker.model.ResourceType] =
      ZIO.succeed(resource)
    def getSuggestionQuery
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.SuggestionQuery.ReadOnly] =
      AwsError.unwrapOptionField("suggestionQuery", suggestionQuery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsRequest
  ) extends zio.aws.sagemaker.model.GetSearchSuggestionsRequest.ReadOnly {
    override val resource: zio.aws.sagemaker.model.ResourceType =
      zio.aws.sagemaker.model.ResourceType.wrap(impl.resource())
    override val suggestionQuery
        : Option[zio.aws.sagemaker.model.SuggestionQuery.ReadOnly] = scala
      .Option(impl.suggestionQuery())
      .map(value => zio.aws.sagemaker.model.SuggestionQuery.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsRequest
  ): zio.aws.sagemaker.model.GetSearchSuggestionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
