package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.AssociationEntityArn
import scala.jdk.CollectionConverters.*
final case class Edge(
    sourceArn: Option[AssociationEntityArn] = None,
    destinationArn: Option[AssociationEntityArn] = None,
    associationType: Option[zio.aws.sagemaker.model.AssociationEdgeType] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.sagemaker.model.Edge = {
    import Edge.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Edge
      .builder()
      .optionallyWith(
        sourceArn.map(value =>
          AssociationEntityArn.unwrap(value): java.lang.String
        )
      )(_.sourceArn)
      .optionallyWith(
        destinationArn.map(value =>
          AssociationEntityArn.unwrap(value): java.lang.String
        )
      )(_.destinationArn)
      .optionallyWith(associationType.map(value => value.unwrap))(
        _.associationType
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Edge.ReadOnly =
    zio.aws.sagemaker.model.Edge.wrap(buildAwsValue())
}
object Edge {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sagemaker.model.Edge] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Edge = zio.aws.sagemaker.model.Edge(
      sourceArn.map(value => value),
      destinationArn.map(value => value),
      associationType.map(value => value)
    )
    def sourceArn: Option[AssociationEntityArn]
    def destinationArn: Option[AssociationEntityArn]
    def associationType: Option[zio.aws.sagemaker.model.AssociationEdgeType]
    def getSourceArn: ZIO[Any, AwsError, AssociationEntityArn] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getDestinationArn: ZIO[Any, AwsError, AssociationEntityArn] =
      AwsError.unwrapOptionField("destinationArn", destinationArn)
    def getAssociationType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AssociationEdgeType] =
      AwsError.unwrapOptionField("associationType", associationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Edge
  ) extends zio.aws.sagemaker.model.Edge.ReadOnly {
    override val sourceArn: Option[AssociationEntityArn] = scala
      .Option(impl.sourceArn())
      .map(value =>
        zio.aws.sagemaker.model.primitives.AssociationEntityArn(value)
      )
    override val destinationArn: Option[AssociationEntityArn] = scala
      .Option(impl.destinationArn())
      .map(value =>
        zio.aws.sagemaker.model.primitives.AssociationEntityArn(value)
      )
    override val associationType
        : Option[zio.aws.sagemaker.model.AssociationEdgeType] = scala
      .Option(impl.associationType())
      .map(value => zio.aws.sagemaker.model.AssociationEdgeType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Edge
  ): zio.aws.sagemaker.model.Edge.ReadOnly = new Wrapper(impl)
}
