package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DriftCheckBaselines(
    bias: Option[zio.aws.sagemaker.model.DriftCheckBias] = None,
    explainability: Option[zio.aws.sagemaker.model.DriftCheckExplainability] =
      None,
    modelQuality: Option[zio.aws.sagemaker.model.DriftCheckModelQuality] = None,
    modelDataQuality: Option[
      zio.aws.sagemaker.model.DriftCheckModelDataQuality
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DriftCheckBaselines = {
    import DriftCheckBaselines.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DriftCheckBaselines
      .builder()
      .optionallyWith(bias.map(value => value.buildAwsValue()))(_.bias)
      .optionallyWith(explainability.map(value => value.buildAwsValue()))(
        _.explainability
      )
      .optionallyWith(modelQuality.map(value => value.buildAwsValue()))(
        _.modelQuality
      )
      .optionallyWith(modelDataQuality.map(value => value.buildAwsValue()))(
        _.modelDataQuality
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DriftCheckBaselines.ReadOnly =
    zio.aws.sagemaker.model.DriftCheckBaselines.wrap(buildAwsValue())
}
object DriftCheckBaselines {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DriftCheckBaselines
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DriftCheckBaselines =
      zio.aws.sagemaker.model.DriftCheckBaselines(
        bias.map(value => value.asEditable),
        explainability.map(value => value.asEditable),
        modelQuality.map(value => value.asEditable),
        modelDataQuality.map(value => value.asEditable)
      )
    def bias: Option[zio.aws.sagemaker.model.DriftCheckBias.ReadOnly]
    def explainability
        : Option[zio.aws.sagemaker.model.DriftCheckExplainability.ReadOnly]
    def modelQuality
        : Option[zio.aws.sagemaker.model.DriftCheckModelQuality.ReadOnly]
    def modelDataQuality
        : Option[zio.aws.sagemaker.model.DriftCheckModelDataQuality.ReadOnly]
    def getBias
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.DriftCheckBias.ReadOnly] =
      AwsError.unwrapOptionField("bias", bias)
    def getExplainability: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DriftCheckExplainability.ReadOnly
    ] = AwsError.unwrapOptionField("explainability", explainability)
    def getModelQuality: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DriftCheckModelQuality.ReadOnly
    ] = AwsError.unwrapOptionField("modelQuality", modelQuality)
    def getModelDataQuality: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DriftCheckModelDataQuality.ReadOnly
    ] = AwsError.unwrapOptionField("modelDataQuality", modelDataQuality)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DriftCheckBaselines
  ) extends zio.aws.sagemaker.model.DriftCheckBaselines.ReadOnly {
    override val bias: Option[zio.aws.sagemaker.model.DriftCheckBias.ReadOnly] =
      scala
        .Option(impl.bias())
        .map(value => zio.aws.sagemaker.model.DriftCheckBias.wrap(value))
    override val explainability
        : Option[zio.aws.sagemaker.model.DriftCheckExplainability.ReadOnly] =
      scala
        .Option(impl.explainability())
        .map(value =>
          zio.aws.sagemaker.model.DriftCheckExplainability.wrap(value)
        )
    override val modelQuality
        : Option[zio.aws.sagemaker.model.DriftCheckModelQuality.ReadOnly] =
      scala
        .Option(impl.modelQuality())
        .map(value =>
          zio.aws.sagemaker.model.DriftCheckModelQuality.wrap(value)
        )
    override val modelDataQuality
        : Option[zio.aws.sagemaker.model.DriftCheckModelDataQuality.ReadOnly] =
      scala
        .Option(impl.modelDataQuality())
        .map(value =>
          zio.aws.sagemaker.model.DriftCheckModelDataQuality.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DriftCheckBaselines
  ): zio.aws.sagemaker.model.DriftCheckBaselines.ReadOnly = new Wrapper(impl)
}
