package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  DeviceArn,
  ThingName,
  EdgeVersion,
  DeviceDescription,
  Timestamp,
  EntityName
}
import scala.jdk.CollectionConverters.*
final case class DeviceSummary(
    deviceName: EntityName,
    deviceArn: DeviceArn,
    description: Option[DeviceDescription] = None,
    deviceFleetName: Option[EntityName] = None,
    iotThingName: Option[ThingName] = None,
    registrationTime: Option[Timestamp] = None,
    latestHeartbeat: Option[Timestamp] = None,
    models: Option[Iterable[zio.aws.sagemaker.model.EdgeModelSummary]] = None,
    agentVersion: Option[EdgeVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeviceSummary = {
    import DeviceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeviceSummary
      .builder()
      .deviceName(EntityName.unwrap(deviceName): java.lang.String)
      .deviceArn(DeviceArn.unwrap(deviceArn): java.lang.String)
      .optionallyWith(
        description.map(value =>
          DeviceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        deviceFleetName.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.deviceFleetName)
      .optionallyWith(
        iotThingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.iotThingName)
      .optionallyWith(
        registrationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.registrationTime)
      .optionallyWith(
        latestHeartbeat.map(value => Timestamp.unwrap(value): Instant)
      )(_.latestHeartbeat)
      .optionallyWith(
        models.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.models)
      .optionallyWith(
        agentVersion.map(value => EdgeVersion.unwrap(value): java.lang.String)
      )(_.agentVersion)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeviceSummary.ReadOnly =
    zio.aws.sagemaker.model.DeviceSummary.wrap(buildAwsValue())
}
object DeviceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeviceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeviceSummary =
      zio.aws.sagemaker.model.DeviceSummary(
        deviceName,
        deviceArn,
        description.map(value => value),
        deviceFleetName.map(value => value),
        iotThingName.map(value => value),
        registrationTime.map(value => value),
        latestHeartbeat.map(value => value),
        models.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        agentVersion.map(value => value)
      )
    def deviceName: EntityName
    def deviceArn: DeviceArn
    def description: Option[DeviceDescription]
    def deviceFleetName: Option[EntityName]
    def iotThingName: Option[ThingName]
    def registrationTime: Option[Timestamp]
    def latestHeartbeat: Option[Timestamp]
    def models: Option[List[zio.aws.sagemaker.model.EdgeModelSummary.ReadOnly]]
    def agentVersion: Option[EdgeVersion]
    def getDeviceName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(deviceName)
    def getDeviceArn: ZIO[Any, Nothing, DeviceArn] = ZIO.succeed(deviceArn)
    def getDescription: ZIO[Any, AwsError, DeviceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDeviceFleetName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("deviceFleetName", deviceFleetName)
    def getIotThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("iotThingName", iotThingName)
    def getRegistrationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("registrationTime", registrationTime)
    def getLatestHeartbeat: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("latestHeartbeat", latestHeartbeat)
    def getModels: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.EdgeModelSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("models", models)
    def getAgentVersion: ZIO[Any, AwsError, EdgeVersion] =
      AwsError.unwrapOptionField("agentVersion", agentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeviceSummary
  ) extends zio.aws.sagemaker.model.DeviceSummary.ReadOnly {
    override val deviceName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.deviceName())
    override val deviceArn: DeviceArn =
      zio.aws.sagemaker.model.primitives.DeviceArn(impl.deviceArn())
    override val description: Option[DeviceDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.sagemaker.model.primitives.DeviceDescription(value))
    override val deviceFleetName: Option[EntityName] = scala
      .Option(impl.deviceFleetName())
      .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
    override val iotThingName: Option[ThingName] = scala
      .Option(impl.iotThingName())
      .map(value => zio.aws.sagemaker.model.primitives.ThingName(value))
    override val registrationTime: Option[Timestamp] = scala
      .Option(impl.registrationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val latestHeartbeat: Option[Timestamp] = scala
      .Option(impl.latestHeartbeat())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val models
        : Option[List[zio.aws.sagemaker.model.EdgeModelSummary.ReadOnly]] =
      scala
        .Option(impl.models())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.EdgeModelSummary.wrap(item)
          }.toList
        )
    override val agentVersion: Option[EdgeVersion] = scala
      .Option(impl.agentVersion())
      .map(value => zio.aws.sagemaker.model.primitives.EdgeVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeviceSummary
  ): zio.aws.sagemaker.model.DeviceSummary.ReadOnly = new Wrapper(impl)
}
