package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  ProjectEntityName,
  ProjectId,
  Timestamp,
  ProjectArn,
  EntityDescription
}
import scala.jdk.CollectionConverters.*
final case class DescribeProjectResponse(
    projectArn: ProjectArn,
    projectName: ProjectEntityName,
    projectId: ProjectId,
    projectDescription: Option[EntityDescription] = None,
    serviceCatalogProvisioningDetails: zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails,
    serviceCatalogProvisionedProductDetails: Option[
      zio.aws.sagemaker.model.ServiceCatalogProvisionedProductDetails
    ] = None,
    projectStatus: zio.aws.sagemaker.model.ProjectStatus,
    createdBy: Option[zio.aws.sagemaker.model.UserContext] = None,
    creationTime: Timestamp,
    lastModifiedTime: Option[Timestamp] = None,
    lastModifiedBy: Option[zio.aws.sagemaker.model.UserContext] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeProjectResponse = {
    import DescribeProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeProjectResponse
      .builder()
      .projectArn(ProjectArn.unwrap(projectArn): java.lang.String)
      .projectName(ProjectEntityName.unwrap(projectName): java.lang.String)
      .projectId(ProjectId.unwrap(projectId): java.lang.String)
      .optionallyWith(
        projectDescription.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.projectDescription)
      .serviceCatalogProvisioningDetails(
        serviceCatalogProvisioningDetails.buildAwsValue()
      )
      .optionallyWith(
        serviceCatalogProvisionedProductDetails.map(value =>
          value.buildAwsValue()
        )
      )(_.serviceCatalogProvisionedProductDetails)
      .projectStatus(projectStatus.unwrap)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeProjectResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeProjectResponse.wrap(buildAwsValue())
}
object DescribeProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeProjectResponse =
      zio.aws.sagemaker.model.DescribeProjectResponse(
        projectArn,
        projectName,
        projectId,
        projectDescription.map(value => value),
        serviceCatalogProvisioningDetails.asEditable,
        serviceCatalogProvisionedProductDetails.map(value => value.asEditable),
        projectStatus,
        createdBy.map(value => value.asEditable),
        creationTime,
        lastModifiedTime.map(value => value),
        lastModifiedBy.map(value => value.asEditable)
      )
    def projectArn: ProjectArn
    def projectName: ProjectEntityName
    def projectId: ProjectId
    def projectDescription: Option[EntityDescription]
    def serviceCatalogProvisioningDetails
        : zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails.ReadOnly
    def serviceCatalogProvisionedProductDetails: Option[
      zio.aws.sagemaker.model.ServiceCatalogProvisionedProductDetails.ReadOnly
    ]
    def projectStatus: zio.aws.sagemaker.model.ProjectStatus
    def createdBy: Option[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def creationTime: Timestamp
    def lastModifiedTime: Option[Timestamp]
    def lastModifiedBy: Option[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def getProjectArn: ZIO[Any, Nothing, ProjectArn] = ZIO.succeed(projectArn)
    def getProjectName: ZIO[Any, Nothing, ProjectEntityName] =
      ZIO.succeed(projectName)
    def getProjectId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(projectId)
    def getProjectDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("projectDescription", projectDescription)
    def getServiceCatalogProvisioningDetails: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails.ReadOnly
    ] = ZIO.succeed(serviceCatalogProvisioningDetails)
    def getServiceCatalogProvisionedProductDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ServiceCatalogProvisionedProductDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceCatalogProvisionedProductDetails",
      serviceCatalogProvisionedProductDetails
    )
    def getProjectStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ProjectStatus] =
      ZIO.succeed(projectStatus)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeProjectResponse
  ) extends zio.aws.sagemaker.model.DescribeProjectResponse.ReadOnly {
    override val projectArn: ProjectArn =
      zio.aws.sagemaker.model.primitives.ProjectArn(impl.projectArn())
    override val projectName: ProjectEntityName =
      zio.aws.sagemaker.model.primitives.ProjectEntityName(impl.projectName())
    override val projectId: ProjectId =
      zio.aws.sagemaker.model.primitives.ProjectId(impl.projectId())
    override val projectDescription: Option[EntityDescription] = scala
      .Option(impl.projectDescription())
      .map(value => zio.aws.sagemaker.model.primitives.EntityDescription(value))
    override val serviceCatalogProvisioningDetails
        : zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails.ReadOnly =
      zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails
        .wrap(impl.serviceCatalogProvisioningDetails())
    override val serviceCatalogProvisionedProductDetails: Option[
      zio.aws.sagemaker.model.ServiceCatalogProvisionedProductDetails.ReadOnly
    ] = scala
      .Option(impl.serviceCatalogProvisionedProductDetails())
      .map(value =>
        zio.aws.sagemaker.model.ServiceCatalogProvisionedProductDetails
          .wrap(value)
      )
    override val projectStatus: zio.aws.sagemaker.model.ProjectStatus =
      zio.aws.sagemaker.model.ProjectStatus.wrap(impl.projectStatus())
    override val createdBy
        : Option[zio.aws.sagemaker.model.UserContext.ReadOnly] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedBy
        : Option[zio.aws.sagemaker.model.UserContext.ReadOnly] = scala
      .Option(impl.lastModifiedBy())
      .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeProjectResponse
  ): zio.aws.sagemaker.model.DescribeProjectResponse.ReadOnly = new Wrapper(
    impl
  )
}
