package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{Timestamp, PipelineDefinition}
import scala.jdk.CollectionConverters.*
final case class DescribePipelineDefinitionForExecutionResponse(
    pipelineDefinition: Option[PipelineDefinition] = None,
    creationTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionResponse = {
    import DescribePipelineDefinitionForExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionResponse
      .builder()
      .optionallyWith(
        pipelineDefinition.map(value =>
          PipelineDefinition.unwrap(value): java.lang.String
        )
      )(_.pipelineDefinition)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribePipelineDefinitionForExecutionResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribePipelineDefinitionForExecutionResponse
      .wrap(buildAwsValue())
}
object DescribePipelineDefinitionForExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DescribePipelineDefinitionForExecutionResponse =
      zio.aws.sagemaker.model.DescribePipelineDefinitionForExecutionResponse(
        pipelineDefinition.map(value => value),
        creationTime.map(value => value)
      )
    def pipelineDefinition: Option[PipelineDefinition]
    def creationTime: Option[Timestamp]
    def getPipelineDefinition: ZIO[Any, AwsError, PipelineDefinition] =
      AwsError.unwrapOptionField("pipelineDefinition", pipelineDefinition)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionResponse
  ) extends zio.aws.sagemaker.model.DescribePipelineDefinitionForExecutionResponse.ReadOnly {
    override val pipelineDefinition: Option[PipelineDefinition] = scala
      .Option(impl.pipelineDefinition())
      .map(value =>
        zio.aws.sagemaker.model.primitives.PipelineDefinition(value)
      )
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionResponse
  ): zio.aws.sagemaker.model.DescribePipelineDefinitionForExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
