package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  ExperimentDescription,
  LineageGroupArn,
  ExperimentEntityName
}
import scala.jdk.CollectionConverters.*
final case class DescribeLineageGroupResponse(
    lineageGroupName: Option[ExperimentEntityName] = None,
    lineageGroupArn: Option[LineageGroupArn] = None,
    displayName: Option[ExperimentEntityName] = None,
    description: Option[ExperimentDescription] = None,
    creationTime: Option[Timestamp] = None,
    createdBy: Option[zio.aws.sagemaker.model.UserContext] = None,
    lastModifiedTime: Option[Timestamp] = None,
    lastModifiedBy: Option[zio.aws.sagemaker.model.UserContext] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeLineageGroupResponse = {
    import DescribeLineageGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeLineageGroupResponse
      .builder()
      .optionallyWith(
        lineageGroupName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.lineageGroupName)
      .optionallyWith(
        lineageGroupArn.map(value =>
          LineageGroupArn.unwrap(value): java.lang.String
        )
      )(_.lineageGroupArn)
      .optionallyWith(
        displayName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        description.map(value =>
          ExperimentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeLineageGroupResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeLineageGroupResponse.wrap(buildAwsValue())
}
object DescribeLineageGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeLineageGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeLineageGroupResponse =
      zio.aws.sagemaker.model.DescribeLineageGroupResponse(
        lineageGroupName.map(value => value),
        lineageGroupArn.map(value => value),
        displayName.map(value => value),
        description.map(value => value),
        creationTime.map(value => value),
        createdBy.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        lastModifiedBy.map(value => value.asEditable)
      )
    def lineageGroupName: Option[ExperimentEntityName]
    def lineageGroupArn: Option[LineageGroupArn]
    def displayName: Option[ExperimentEntityName]
    def description: Option[ExperimentDescription]
    def creationTime: Option[Timestamp]
    def createdBy: Option[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def lastModifiedTime: Option[Timestamp]
    def lastModifiedBy: Option[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def getLineageGroupName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("lineageGroupName", lineageGroupName)
    def getLineageGroupArn: ZIO[Any, AwsError, LineageGroupArn] =
      AwsError.unwrapOptionField("lineageGroupArn", lineageGroupArn)
    def getDisplayName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, ExperimentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeLineageGroupResponse
  ) extends zio.aws.sagemaker.model.DescribeLineageGroupResponse.ReadOnly {
    override val lineageGroupName: Option[ExperimentEntityName] = scala
      .Option(impl.lineageGroupName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
      )
    override val lineageGroupArn: Option[LineageGroupArn] = scala
      .Option(impl.lineageGroupArn())
      .map(value => zio.aws.sagemaker.model.primitives.LineageGroupArn(value))
    override val displayName: Option[ExperimentEntityName] = scala
      .Option(impl.displayName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
      )
    override val description: Option[ExperimentDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentDescription(value)
      )
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBy
        : Option[zio.aws.sagemaker.model.UserContext.ReadOnly] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedBy
        : Option[zio.aws.sagemaker.model.UserContext.ReadOnly] = scala
      .Option(impl.lastModifiedBy())
      .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeLineageGroupResponse
  ): zio.aws.sagemaker.model.DescribeLineageGroupResponse.ReadOnly =
    new Wrapper(impl)
}
