package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  Timestamp,
  MonitoringJobDefinitionName,
  MonitoringJobDefinitionArn
}
import scala.jdk.CollectionConverters.*
final case class DescribeDataQualityJobDefinitionResponse(
    jobDefinitionArn: MonitoringJobDefinitionArn,
    jobDefinitionName: MonitoringJobDefinitionName,
    creationTime: Timestamp,
    dataQualityBaselineConfig: Option[
      zio.aws.sagemaker.model.DataQualityBaselineConfig
    ] = None,
    dataQualityAppSpecification: zio.aws.sagemaker.model.DataQualityAppSpecification,
    dataQualityJobInput: zio.aws.sagemaker.model.DataQualityJobInput,
    dataQualityJobOutputConfig: zio.aws.sagemaker.model.MonitoringOutputConfig,
    jobResources: zio.aws.sagemaker.model.MonitoringResources,
    networkConfig: Option[zio.aws.sagemaker.model.MonitoringNetworkConfig] =
      None,
    roleArn: RoleArn,
    stoppingCondition: Option[
      zio.aws.sagemaker.model.MonitoringStoppingCondition
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeDataQualityJobDefinitionResponse = {
    import DescribeDataQualityJobDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeDataQualityJobDefinitionResponse
      .builder()
      .jobDefinitionArn(
        MonitoringJobDefinitionArn.unwrap(jobDefinitionArn): java.lang.String
      )
      .jobDefinitionName(
        MonitoringJobDefinitionName.unwrap(jobDefinitionName): java.lang.String
      )
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(
        dataQualityBaselineConfig.map(value => value.buildAwsValue())
      )(_.dataQualityBaselineConfig)
      .dataQualityAppSpecification(dataQualityAppSpecification.buildAwsValue())
      .dataQualityJobInput(dataQualityJobInput.buildAwsValue())
      .dataQualityJobOutputConfig(dataQualityJobOutputConfig.buildAwsValue())
      .jobResources(jobResources.buildAwsValue())
      .optionallyWith(networkConfig.map(value => value.buildAwsValue()))(
        _.networkConfig
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(stoppingCondition.map(value => value.buildAwsValue()))(
        _.stoppingCondition
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeDataQualityJobDefinitionResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeDataQualityJobDefinitionResponse
      .wrap(buildAwsValue())
}
object DescribeDataQualityJobDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeDataQualityJobDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DescribeDataQualityJobDefinitionResponse =
      zio.aws.sagemaker.model.DescribeDataQualityJobDefinitionResponse(
        jobDefinitionArn,
        jobDefinitionName,
        creationTime,
        dataQualityBaselineConfig.map(value => value.asEditable),
        dataQualityAppSpecification.asEditable,
        dataQualityJobInput.asEditable,
        dataQualityJobOutputConfig.asEditable,
        jobResources.asEditable,
        networkConfig.map(value => value.asEditable),
        roleArn,
        stoppingCondition.map(value => value.asEditable)
      )
    def jobDefinitionArn: MonitoringJobDefinitionArn
    def jobDefinitionName: MonitoringJobDefinitionName
    def creationTime: Timestamp
    def dataQualityBaselineConfig
        : Option[zio.aws.sagemaker.model.DataQualityBaselineConfig.ReadOnly]
    def dataQualityAppSpecification
        : zio.aws.sagemaker.model.DataQualityAppSpecification.ReadOnly
    def dataQualityJobInput
        : zio.aws.sagemaker.model.DataQualityJobInput.ReadOnly
    def dataQualityJobOutputConfig
        : zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly
    def jobResources: zio.aws.sagemaker.model.MonitoringResources.ReadOnly
    def networkConfig
        : Option[zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly]
    def roleArn: RoleArn
    def stoppingCondition
        : Option[zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly]
    def getJobDefinitionArn: ZIO[Any, Nothing, MonitoringJobDefinitionArn] =
      ZIO.succeed(jobDefinitionArn)
    def getJobDefinitionName: ZIO[Any, Nothing, MonitoringJobDefinitionName] =
      ZIO.succeed(jobDefinitionName)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getDataQualityBaselineConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DataQualityBaselineConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataQualityBaselineConfig",
      dataQualityBaselineConfig
    )
    def getDataQualityAppSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.DataQualityAppSpecification.ReadOnly
    ] = ZIO.succeed(dataQualityAppSpecification)
    def getDataQualityJobInput: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.DataQualityJobInput.ReadOnly
    ] = ZIO.succeed(dataQualityJobInput)
    def getDataQualityJobOutputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly
    ] = ZIO.succeed(dataQualityJobOutputConfig)
    def getJobResources: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringResources.ReadOnly
    ] = ZIO.succeed(jobResources)
    def getNetworkConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly
    ] = AwsError.unwrapOptionField("networkConfig", networkConfig)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getStoppingCondition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly
    ] = AwsError.unwrapOptionField("stoppingCondition", stoppingCondition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeDataQualityJobDefinitionResponse
  ) extends zio.aws.sagemaker.model.DescribeDataQualityJobDefinitionResponse.ReadOnly {
    override val jobDefinitionArn: MonitoringJobDefinitionArn =
      zio.aws.sagemaker.model.primitives
        .MonitoringJobDefinitionArn(impl.jobDefinitionArn())
    override val jobDefinitionName: MonitoringJobDefinitionName =
      zio.aws.sagemaker.model.primitives
        .MonitoringJobDefinitionName(impl.jobDefinitionName())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val dataQualityBaselineConfig
        : Option[zio.aws.sagemaker.model.DataQualityBaselineConfig.ReadOnly] =
      scala
        .Option(impl.dataQualityBaselineConfig())
        .map(value =>
          zio.aws.sagemaker.model.DataQualityBaselineConfig.wrap(value)
        )
    override val dataQualityAppSpecification
        : zio.aws.sagemaker.model.DataQualityAppSpecification.ReadOnly =
      zio.aws.sagemaker.model.DataQualityAppSpecification
        .wrap(impl.dataQualityAppSpecification())
    override val dataQualityJobInput
        : zio.aws.sagemaker.model.DataQualityJobInput.ReadOnly =
      zio.aws.sagemaker.model.DataQualityJobInput
        .wrap(impl.dataQualityJobInput())
    override val dataQualityJobOutputConfig
        : zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly =
      zio.aws.sagemaker.model.MonitoringOutputConfig
        .wrap(impl.dataQualityJobOutputConfig())
    override val jobResources
        : zio.aws.sagemaker.model.MonitoringResources.ReadOnly =
      zio.aws.sagemaker.model.MonitoringResources.wrap(impl.jobResources())
    override val networkConfig
        : Option[zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly] =
      scala
        .Option(impl.networkConfig())
        .map(value =>
          zio.aws.sagemaker.model.MonitoringNetworkConfig.wrap(value)
        )
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val stoppingCondition
        : Option[zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly] =
      scala
        .Option(impl.stoppingCondition())
        .map(value =>
          zio.aws.sagemaker.model.MonitoringStoppingCondition.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeDataQualityJobDefinitionResponse
  ): zio.aws.sagemaker.model.DescribeDataQualityJobDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
