package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  CertifyForMarketplace,
  AlgorithmArn,
  EntityDescription,
  ProductId,
  EntityName
}
import scala.jdk.CollectionConverters.*
final case class DescribeAlgorithmResponse(
    algorithmName: EntityName,
    algorithmArn: AlgorithmArn,
    algorithmDescription: Option[EntityDescription] = None,
    creationTime: CreationTime,
    trainingSpecification: zio.aws.sagemaker.model.TrainingSpecification,
    inferenceSpecification: Option[
      zio.aws.sagemaker.model.InferenceSpecification
    ] = None,
    validationSpecification: Option[
      zio.aws.sagemaker.model.AlgorithmValidationSpecification
    ] = None,
    algorithmStatus: zio.aws.sagemaker.model.AlgorithmStatus,
    algorithmStatusDetails: zio.aws.sagemaker.model.AlgorithmStatusDetails,
    productId: Option[ProductId] = None,
    certifyForMarketplace: Option[CertifyForMarketplace] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmResponse = {
    import DescribeAlgorithmResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmResponse
      .builder()
      .algorithmName(EntityName.unwrap(algorithmName): java.lang.String)
      .algorithmArn(AlgorithmArn.unwrap(algorithmArn): java.lang.String)
      .optionallyWith(
        algorithmDescription.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.algorithmDescription)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .trainingSpecification(trainingSpecification.buildAwsValue())
      .optionallyWith(
        inferenceSpecification.map(value => value.buildAwsValue())
      )(_.inferenceSpecification)
      .optionallyWith(
        validationSpecification.map(value => value.buildAwsValue())
      )(_.validationSpecification)
      .algorithmStatus(algorithmStatus.unwrap)
      .algorithmStatusDetails(algorithmStatusDetails.buildAwsValue())
      .optionallyWith(
        productId.map(value => ProductId.unwrap(value): java.lang.String)
      )(_.productId)
      .optionallyWith(
        certifyForMarketplace.map(value =>
          CertifyForMarketplace.unwrap(value): java.lang.Boolean
        )
      )(_.certifyForMarketplace)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeAlgorithmResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeAlgorithmResponse.wrap(buildAwsValue())
}
object DescribeAlgorithmResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeAlgorithmResponse =
      zio.aws.sagemaker.model.DescribeAlgorithmResponse(
        algorithmName,
        algorithmArn,
        algorithmDescription.map(value => value),
        creationTime,
        trainingSpecification.asEditable,
        inferenceSpecification.map(value => value.asEditable),
        validationSpecification.map(value => value.asEditable),
        algorithmStatus,
        algorithmStatusDetails.asEditable,
        productId.map(value => value),
        certifyForMarketplace.map(value => value)
      )
    def algorithmName: EntityName
    def algorithmArn: AlgorithmArn
    def algorithmDescription: Option[EntityDescription]
    def creationTime: CreationTime
    def trainingSpecification
        : zio.aws.sagemaker.model.TrainingSpecification.ReadOnly
    def inferenceSpecification
        : Option[zio.aws.sagemaker.model.InferenceSpecification.ReadOnly]
    def validationSpecification: Option[
      zio.aws.sagemaker.model.AlgorithmValidationSpecification.ReadOnly
    ]
    def algorithmStatus: zio.aws.sagemaker.model.AlgorithmStatus
    def algorithmStatusDetails
        : zio.aws.sagemaker.model.AlgorithmStatusDetails.ReadOnly
    def productId: Option[ProductId]
    def certifyForMarketplace: Option[CertifyForMarketplace]
    def getAlgorithmName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(algorithmName)
    def getAlgorithmArn: ZIO[Any, Nothing, AlgorithmArn] =
      ZIO.succeed(algorithmArn)
    def getAlgorithmDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("algorithmDescription", algorithmDescription)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getTrainingSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.TrainingSpecification.ReadOnly
    ] = ZIO.succeed(trainingSpecification)
    def getInferenceSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.InferenceSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inferenceSpecification",
      inferenceSpecification
    )
    def getValidationSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AlgorithmValidationSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "validationSpecification",
      validationSpecification
    )
    def getAlgorithmStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.AlgorithmStatus] =
      ZIO.succeed(algorithmStatus)
    def getAlgorithmStatusDetails: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.AlgorithmStatusDetails.ReadOnly
    ] = ZIO.succeed(algorithmStatusDetails)
    def getProductId: ZIO[Any, AwsError, ProductId] =
      AwsError.unwrapOptionField("productId", productId)
    def getCertifyForMarketplace: ZIO[Any, AwsError, CertifyForMarketplace] =
      AwsError.unwrapOptionField("certifyForMarketplace", certifyForMarketplace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmResponse
  ) extends zio.aws.sagemaker.model.DescribeAlgorithmResponse.ReadOnly {
    override val algorithmName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.algorithmName())
    override val algorithmArn: AlgorithmArn =
      zio.aws.sagemaker.model.primitives.AlgorithmArn(impl.algorithmArn())
    override val algorithmDescription: Option[EntityDescription] = scala
      .Option(impl.algorithmDescription())
      .map(value => zio.aws.sagemaker.model.primitives.EntityDescription(value))
    override val creationTime: CreationTime =
      zio.aws.sagemaker.model.primitives.CreationTime(impl.creationTime())
    override val trainingSpecification
        : zio.aws.sagemaker.model.TrainingSpecification.ReadOnly =
      zio.aws.sagemaker.model.TrainingSpecification
        .wrap(impl.trainingSpecification())
    override val inferenceSpecification
        : Option[zio.aws.sagemaker.model.InferenceSpecification.ReadOnly] =
      scala
        .Option(impl.inferenceSpecification())
        .map(value =>
          zio.aws.sagemaker.model.InferenceSpecification.wrap(value)
        )
    override val validationSpecification: Option[
      zio.aws.sagemaker.model.AlgorithmValidationSpecification.ReadOnly
    ] = scala
      .Option(impl.validationSpecification())
      .map(value =>
        zio.aws.sagemaker.model.AlgorithmValidationSpecification.wrap(value)
      )
    override val algorithmStatus: zio.aws.sagemaker.model.AlgorithmStatus =
      zio.aws.sagemaker.model.AlgorithmStatus.wrap(impl.algorithmStatus())
    override val algorithmStatusDetails
        : zio.aws.sagemaker.model.AlgorithmStatusDetails.ReadOnly =
      zio.aws.sagemaker.model.AlgorithmStatusDetails
        .wrap(impl.algorithmStatusDetails())
    override val productId: Option[ProductId] = scala
      .Option(impl.productId())
      .map(value => zio.aws.sagemaker.model.primitives.ProductId(value))
    override val certifyForMarketplace: Option[CertifyForMarketplace] = scala
      .Option(impl.certifyForMarketplace())
      .map(value =>
        zio.aws.sagemaker.model.primitives.CertifyForMarketplace(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmResponse
  ): zio.aws.sagemaker.model.DescribeAlgorithmResponse.ReadOnly = new Wrapper(
    impl
  )
}
