package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  ExperimentDescription,
  ExperimentEntityNameOrArn,
  Timestamp,
  ActionArn,
  LineageGroupArn,
  String256,
  StringParameterValue
}
import scala.jdk.CollectionConverters.*
final case class DescribeActionResponse(
    actionName: Option[ExperimentEntityNameOrArn] = None,
    actionArn: Option[ActionArn] = None,
    source: Option[zio.aws.sagemaker.model.ActionSource] = None,
    actionType: Option[String256] = None,
    description: Option[ExperimentDescription] = None,
    status: Option[zio.aws.sagemaker.model.ActionStatus] = None,
    properties: Option[Map[StringParameterValue, StringParameterValue]] = None,
    creationTime: Option[Timestamp] = None,
    createdBy: Option[zio.aws.sagemaker.model.UserContext] = None,
    lastModifiedTime: Option[Timestamp] = None,
    lastModifiedBy: Option[zio.aws.sagemaker.model.UserContext] = None,
    metadataProperties: Option[zio.aws.sagemaker.model.MetadataProperties] =
      None,
    lineageGroupArn: Option[LineageGroupArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeActionResponse = {
    import DescribeActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeActionResponse
      .builder()
      .optionallyWith(
        actionName.map(value =>
          ExperimentEntityNameOrArn.unwrap(value): java.lang.String
        )
      )(_.actionName)
      .optionallyWith(
        actionArn.map(value => ActionArn.unwrap(value): java.lang.String)
      )(_.actionArn)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(
        actionType.map(value => String256.unwrap(value): java.lang.String)
      )(_.actionType)
      .optionallyWith(
        description.map(value =>
          ExperimentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (StringParameterValue.unwrap(
                key
              ): java.lang.String) -> (StringParameterValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.properties)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .optionallyWith(metadataProperties.map(value => value.buildAwsValue()))(
        _.metadataProperties
      )
      .optionallyWith(
        lineageGroupArn.map(value =>
          LineageGroupArn.unwrap(value): java.lang.String
        )
      )(_.lineageGroupArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeActionResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeActionResponse.wrap(buildAwsValue())
}
object DescribeActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeActionResponse =
      zio.aws.sagemaker.model.DescribeActionResponse(
        actionName.map(value => value),
        actionArn.map(value => value),
        source.map(value => value.asEditable),
        actionType.map(value => value),
        description.map(value => value),
        status.map(value => value),
        properties.map(value => value),
        creationTime.map(value => value),
        createdBy.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        lastModifiedBy.map(value => value.asEditable),
        metadataProperties.map(value => value.asEditable),
        lineageGroupArn.map(value => value)
      )
    def actionName: Option[ExperimentEntityNameOrArn]
    def actionArn: Option[ActionArn]
    def source: Option[zio.aws.sagemaker.model.ActionSource.ReadOnly]
    def actionType: Option[String256]
    def description: Option[ExperimentDescription]
    def status: Option[zio.aws.sagemaker.model.ActionStatus]
    def properties: Option[Map[StringParameterValue, StringParameterValue]]
    def creationTime: Option[Timestamp]
    def createdBy: Option[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def lastModifiedTime: Option[Timestamp]
    def lastModifiedBy: Option[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def metadataProperties
        : Option[zio.aws.sagemaker.model.MetadataProperties.ReadOnly]
    def lineageGroupArn: Option[LineageGroupArn]
    def getActionName: ZIO[Any, AwsError, ExperimentEntityNameOrArn] =
      AwsError.unwrapOptionField("actionName", actionName)
    def getActionArn: ZIO[Any, AwsError, ActionArn] =
      AwsError.unwrapOptionField("actionArn", actionArn)
    def getSource
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ActionSource.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
    def getActionType: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("actionType", actionType)
    def getDescription: ZIO[Any, AwsError, ExperimentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[Any, AwsError, zio.aws.sagemaker.model.ActionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getProperties
        : ZIO[Any, AwsError, Map[StringParameterValue, StringParameterValue]] =
      AwsError.unwrapOptionField("properties", properties)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getMetadataProperties: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MetadataProperties.ReadOnly
    ] = AwsError.unwrapOptionField("metadataProperties", metadataProperties)
    def getLineageGroupArn: ZIO[Any, AwsError, LineageGroupArn] =
      AwsError.unwrapOptionField("lineageGroupArn", lineageGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeActionResponse
  ) extends zio.aws.sagemaker.model.DescribeActionResponse.ReadOnly {
    override val actionName: Option[ExperimentEntityNameOrArn] = scala
      .Option(impl.actionName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentEntityNameOrArn(value)
      )
    override val actionArn: Option[ActionArn] = scala
      .Option(impl.actionArn())
      .map(value => zio.aws.sagemaker.model.primitives.ActionArn(value))
    override val source: Option[zio.aws.sagemaker.model.ActionSource.ReadOnly] =
      scala
        .Option(impl.source())
        .map(value => zio.aws.sagemaker.model.ActionSource.wrap(value))
    override val actionType: Option[String256] = scala
      .Option(impl.actionType())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val description: Option[ExperimentDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentDescription(value)
      )
    override val status: Option[zio.aws.sagemaker.model.ActionStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.sagemaker.model.ActionStatus.wrap(value))
    override val properties
        : Option[Map[StringParameterValue, StringParameterValue]] = scala
      .Option(impl.properties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.StringParameterValue(
              key
            ) -> zio.aws.sagemaker.model.primitives.StringParameterValue(value)
          })
          .toMap
      )
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBy
        : Option[zio.aws.sagemaker.model.UserContext.ReadOnly] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedBy
        : Option[zio.aws.sagemaker.model.UserContext.ReadOnly] = scala
      .Option(impl.lastModifiedBy())
      .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val metadataProperties
        : Option[zio.aws.sagemaker.model.MetadataProperties.ReadOnly] = scala
      .Option(impl.metadataProperties())
      .map(value => zio.aws.sagemaker.model.MetadataProperties.wrap(value))
    override val lineageGroupArn: Option[LineageGroupArn] = scala
      .Option(impl.lineageGroupArn())
      .map(value => zio.aws.sagemaker.model.primitives.LineageGroupArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeActionResponse
  ): zio.aws.sagemaker.model.DescribeActionResponse.ReadOnly = new Wrapper(impl)
}
