package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{Timestamp, ContainerImage}
import scala.jdk.CollectionConverters.*
final case class DeployedImage(
    specifiedImage: Option[ContainerImage] = None,
    resolvedImage: Option[ContainerImage] = None,
    resolutionTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeployedImage = {
    import DeployedImage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeployedImage
      .builder()
      .optionallyWith(
        specifiedImage.map(value =>
          ContainerImage.unwrap(value): java.lang.String
        )
      )(_.specifiedImage)
      .optionallyWith(
        resolvedImage.map(value =>
          ContainerImage.unwrap(value): java.lang.String
        )
      )(_.resolvedImage)
      .optionallyWith(
        resolutionTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.resolutionTime)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeployedImage.ReadOnly =
    zio.aws.sagemaker.model.DeployedImage.wrap(buildAwsValue())
}
object DeployedImage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeployedImage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeployedImage =
      zio.aws.sagemaker.model.DeployedImage(
        specifiedImage.map(value => value),
        resolvedImage.map(value => value),
        resolutionTime.map(value => value)
      )
    def specifiedImage: Option[ContainerImage]
    def resolvedImage: Option[ContainerImage]
    def resolutionTime: Option[Timestamp]
    def getSpecifiedImage: ZIO[Any, AwsError, ContainerImage] =
      AwsError.unwrapOptionField("specifiedImage", specifiedImage)
    def getResolvedImage: ZIO[Any, AwsError, ContainerImage] =
      AwsError.unwrapOptionField("resolvedImage", resolvedImage)
    def getResolutionTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("resolutionTime", resolutionTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeployedImage
  ) extends zio.aws.sagemaker.model.DeployedImage.ReadOnly {
    override val specifiedImage: Option[ContainerImage] = scala
      .Option(impl.specifiedImage())
      .map(value => zio.aws.sagemaker.model.primitives.ContainerImage(value))
    override val resolvedImage: Option[ContainerImage] = scala
      .Option(impl.resolvedImage())
      .map(value => zio.aws.sagemaker.model.primitives.ContainerImage(value))
    override val resolutionTime: Option[Timestamp] = scala
      .Option(impl.resolutionTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeployedImage
  ): zio.aws.sagemaker.model.DeployedImage.ReadOnly = new Wrapper(impl)
}
