package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.TrialArn
import scala.jdk.CollectionConverters.*
final case class DeleteTrialResponse(trialArn: Option[TrialArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteTrialResponse = {
    import DeleteTrialResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteTrialResponse
      .builder()
      .optionallyWith(
        trialArn.map(value => TrialArn.unwrap(value): java.lang.String)
      )(_.trialArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteTrialResponse.ReadOnly =
    zio.aws.sagemaker.model.DeleteTrialResponse.wrap(buildAwsValue())
}
object DeleteTrialResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteTrialResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteTrialResponse =
      zio.aws.sagemaker.model.DeleteTrialResponse(trialArn.map(value => value))
    def trialArn: Option[TrialArn]
    def getTrialArn: ZIO[Any, AwsError, TrialArn] =
      AwsError.unwrapOptionField("trialArn", trialArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteTrialResponse
  ) extends zio.aws.sagemaker.model.DeleteTrialResponse.ReadOnly {
    override val trialArn: Option[TrialArn] = scala
      .Option(impl.trialArn())
      .map(value => zio.aws.sagemaker.model.primitives.TrialArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteTrialResponse
  ): zio.aws.sagemaker.model.DeleteTrialResponse.ReadOnly = new Wrapper(impl)
}
