package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ArnOrName
import scala.jdk.CollectionConverters.*
final case class DeleteModelPackageGroupRequest(
    modelPackageGroupName: ArnOrName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupRequest = {
    import DeleteModelPackageGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupRequest
      .builder()
      .modelPackageGroupName(
        ArnOrName.unwrap(modelPackageGroupName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DeleteModelPackageGroupRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteModelPackageGroupRequest.wrap(buildAwsValue())
}
object DeleteModelPackageGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteModelPackageGroupRequest =
      zio.aws.sagemaker.model
        .DeleteModelPackageGroupRequest(modelPackageGroupName)
    def modelPackageGroupName: ArnOrName
    def getModelPackageGroupName: ZIO[Any, Nothing, ArnOrName] =
      ZIO.succeed(modelPackageGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupRequest
  ) extends zio.aws.sagemaker.model.DeleteModelPackageGroupRequest.ReadOnly {
    override val modelPackageGroupName: ArnOrName =
      zio.aws.sagemaker.model.primitives.ArnOrName(impl.modelPackageGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupRequest
  ): zio.aws.sagemaker.model.DeleteModelPackageGroupRequest.ReadOnly =
    new Wrapper(impl)
}
