package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  ConfigValue,
  ConfigKey,
  S3Uri,
  DirectoryPath
}
import scala.jdk.CollectionConverters.*
final case class DebugHookConfig(
    localPath: Option[DirectoryPath] = None,
    s3OutputPath: S3Uri,
    hookParameters: Option[Map[ConfigKey, ConfigValue]] = None,
    collectionConfigurations: Option[
      Iterable[zio.aws.sagemaker.model.CollectionConfiguration]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DebugHookConfig = {
    import DebugHookConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DebugHookConfig
      .builder()
      .optionallyWith(
        localPath.map(value => DirectoryPath.unwrap(value): java.lang.String)
      )(_.localPath)
      .s3OutputPath(S3Uri.unwrap(s3OutputPath): java.lang.String)
      .optionallyWith(
        hookParameters.map(value =>
          value
            .map({ case (key, value) =>
              (ConfigKey.unwrap(key): java.lang.String) -> (ConfigValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.hookParameters)
      .optionallyWith(
        collectionConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.collectionConfigurations)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DebugHookConfig.ReadOnly =
    zio.aws.sagemaker.model.DebugHookConfig.wrap(buildAwsValue())
}
object DebugHookConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DebugHookConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DebugHookConfig =
      zio.aws.sagemaker.model.DebugHookConfig(
        localPath.map(value => value),
        s3OutputPath,
        hookParameters.map(value => value),
        collectionConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def localPath: Option[DirectoryPath]
    def s3OutputPath: S3Uri
    def hookParameters: Option[Map[ConfigKey, ConfigValue]]
    def collectionConfigurations
        : Option[List[zio.aws.sagemaker.model.CollectionConfiguration.ReadOnly]]
    def getLocalPath: ZIO[Any, AwsError, DirectoryPath] =
      AwsError.unwrapOptionField("localPath", localPath)
    def getS3OutputPath: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3OutputPath)
    def getHookParameters: ZIO[Any, AwsError, Map[ConfigKey, ConfigValue]] =
      AwsError.unwrapOptionField("hookParameters", hookParameters)
    def getCollectionConfigurations: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.CollectionConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "collectionConfigurations",
      collectionConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DebugHookConfig
  ) extends zio.aws.sagemaker.model.DebugHookConfig.ReadOnly {
    override val localPath: Option[DirectoryPath] = scala
      .Option(impl.localPath())
      .map(value => zio.aws.sagemaker.model.primitives.DirectoryPath(value))
    override val s3OutputPath: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.s3OutputPath())
    override val hookParameters: Option[Map[ConfigKey, ConfigValue]] = scala
      .Option(impl.hookParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.ConfigKey(
              key
            ) -> zio.aws.sagemaker.model.primitives.ConfigValue(value)
          })
          .toMap
      )
    override val collectionConfigurations: Option[
      List[zio.aws.sagemaker.model.CollectionConfiguration.ReadOnly]
    ] = scala
      .Option(impl.collectionConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.CollectionConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DebugHookConfig
  ): zio.aws.sagemaker.model.DebugHookConfig.ReadOnly = new Wrapper(impl)
}
