package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.JsonPath
import scala.jdk.CollectionConverters.*
final case class DataProcessing(
    inputFilter: Option[JsonPath] = None,
    outputFilter: Option[JsonPath] = None,
    joinSource: Option[zio.aws.sagemaker.model.JoinSource] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DataProcessing = {
    import DataProcessing.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DataProcessing
      .builder()
      .optionallyWith(
        inputFilter.map(value => JsonPath.unwrap(value): java.lang.String)
      )(_.inputFilter)
      .optionallyWith(
        outputFilter.map(value => JsonPath.unwrap(value): java.lang.String)
      )(_.outputFilter)
      .optionallyWith(joinSource.map(value => value.unwrap))(_.joinSource)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DataProcessing.ReadOnly =
    zio.aws.sagemaker.model.DataProcessing.wrap(buildAwsValue())
}
object DataProcessing {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DataProcessing
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DataProcessing =
      zio.aws.sagemaker.model.DataProcessing(
        inputFilter.map(value => value),
        outputFilter.map(value => value),
        joinSource.map(value => value)
      )
    def inputFilter: Option[JsonPath]
    def outputFilter: Option[JsonPath]
    def joinSource: Option[zio.aws.sagemaker.model.JoinSource]
    def getInputFilter: ZIO[Any, AwsError, JsonPath] =
      AwsError.unwrapOptionField("inputFilter", inputFilter)
    def getOutputFilter: ZIO[Any, AwsError, JsonPath] =
      AwsError.unwrapOptionField("outputFilter", outputFilter)
    def getJoinSource: ZIO[Any, AwsError, zio.aws.sagemaker.model.JoinSource] =
      AwsError.unwrapOptionField("joinSource", joinSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DataProcessing
  ) extends zio.aws.sagemaker.model.DataProcessing.ReadOnly {
    override val inputFilter: Option[JsonPath] = scala
      .Option(impl.inputFilter())
      .map(value => zio.aws.sagemaker.model.primitives.JsonPath(value))
    override val outputFilter: Option[JsonPath] = scala
      .Option(impl.outputFilter())
      .map(value => zio.aws.sagemaker.model.primitives.JsonPath(value))
    override val joinSource: Option[zio.aws.sagemaker.model.JoinSource] = scala
      .Option(impl.joinSource())
      .map(value => zio.aws.sagemaker.model.JoinSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DataProcessing
  ): zio.aws.sagemaker.model.DataProcessing.ReadOnly = new Wrapper(impl)
}
