package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  KmsKeyId,
  DestinationS3Uri,
  SamplingPercentage,
  EnableCapture
}
import scala.jdk.CollectionConverters.*
final case class DataCaptureConfig(
    enableCapture: Option[EnableCapture] = None,
    initialSamplingPercentage: SamplingPercentage,
    destinationS3Uri: DestinationS3Uri,
    kmsKeyId: Option[KmsKeyId] = None,
    captureOptions: Iterable[zio.aws.sagemaker.model.CaptureOption],
    captureContentTypeHeader: Option[
      zio.aws.sagemaker.model.CaptureContentTypeHeader
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DataCaptureConfig = {
    import DataCaptureConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DataCaptureConfig
      .builder()
      .optionallyWith(
        enableCapture.map(value =>
          EnableCapture.unwrap(value): java.lang.Boolean
        )
      )(_.enableCapture)
      .initialSamplingPercentage(
        SamplingPercentage.unwrap(initialSamplingPercentage): Integer
      )
      .destinationS3Uri(
        DestinationS3Uri.unwrap(destinationS3Uri): java.lang.String
      )
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .captureOptions(captureOptions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        captureContentTypeHeader.map(value => value.buildAwsValue())
      )(_.captureContentTypeHeader)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DataCaptureConfig.ReadOnly =
    zio.aws.sagemaker.model.DataCaptureConfig.wrap(buildAwsValue())
}
object DataCaptureConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DataCaptureConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DataCaptureConfig =
      zio.aws.sagemaker.model.DataCaptureConfig(
        enableCapture.map(value => value),
        initialSamplingPercentage,
        destinationS3Uri,
        kmsKeyId.map(value => value),
        captureOptions.map { item =>
          item.asEditable
        },
        captureContentTypeHeader.map(value => value.asEditable)
      )
    def enableCapture: Option[EnableCapture]
    def initialSamplingPercentage: SamplingPercentage
    def destinationS3Uri: DestinationS3Uri
    def kmsKeyId: Option[KmsKeyId]
    def captureOptions: List[zio.aws.sagemaker.model.CaptureOption.ReadOnly]
    def captureContentTypeHeader
        : Option[zio.aws.sagemaker.model.CaptureContentTypeHeader.ReadOnly]
    def getEnableCapture: ZIO[Any, AwsError, EnableCapture] =
      AwsError.unwrapOptionField("enableCapture", enableCapture)
    def getInitialSamplingPercentage: ZIO[Any, Nothing, SamplingPercentage] =
      ZIO.succeed(initialSamplingPercentage)
    def getDestinationS3Uri: ZIO[Any, Nothing, DestinationS3Uri] =
      ZIO.succeed(destinationS3Uri)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getCaptureOptions: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.CaptureOption.ReadOnly
    ]] = ZIO.succeed(captureOptions)
    def getCaptureContentTypeHeader: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.CaptureContentTypeHeader.ReadOnly
    ] = AwsError.unwrapOptionField(
      "captureContentTypeHeader",
      captureContentTypeHeader
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DataCaptureConfig
  ) extends zio.aws.sagemaker.model.DataCaptureConfig.ReadOnly {
    override val enableCapture: Option[EnableCapture] = scala
      .Option(impl.enableCapture())
      .map(value => zio.aws.sagemaker.model.primitives.EnableCapture(value))
    override val initialSamplingPercentage: SamplingPercentage =
      zio.aws.sagemaker.model.primitives
        .SamplingPercentage(impl.initialSamplingPercentage())
    override val destinationS3Uri: DestinationS3Uri =
      zio.aws.sagemaker.model.primitives
        .DestinationS3Uri(impl.destinationS3Uri())
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val captureOptions
        : List[zio.aws.sagemaker.model.CaptureOption.ReadOnly] = impl
      .captureOptions()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.CaptureOption.wrap(item)
      }
      .toList
    override val captureContentTypeHeader
        : Option[zio.aws.sagemaker.model.CaptureContentTypeHeader.ReadOnly] =
      scala
        .Option(impl.captureContentTypeHeader())
        .map(value =>
          zio.aws.sagemaker.model.CaptureContentTypeHeader.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DataCaptureConfig
  ): zio.aws.sagemaker.model.DataCaptureConfig.ReadOnly = new Wrapper(impl)
}
