package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.TrialComponentArn
import scala.jdk.CollectionConverters.*
final case class CreateTrialComponentResponse(
    trialComponentArn: Option[TrialComponentArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateTrialComponentResponse = {
    import CreateTrialComponentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateTrialComponentResponse
      .builder()
      .optionallyWith(
        trialComponentArn.map(value =>
          TrialComponentArn.unwrap(value): java.lang.String
        )
      )(_.trialComponentArn)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateTrialComponentResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateTrialComponentResponse.wrap(buildAwsValue())
}
object CreateTrialComponentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateTrialComponentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateTrialComponentResponse =
      zio.aws.sagemaker.model
        .CreateTrialComponentResponse(trialComponentArn.map(value => value))
    def trialComponentArn: Option[TrialComponentArn]
    def getTrialComponentArn: ZIO[Any, AwsError, TrialComponentArn] =
      AwsError.unwrapOptionField("trialComponentArn", trialComponentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateTrialComponentResponse
  ) extends zio.aws.sagemaker.model.CreateTrialComponentResponse.ReadOnly {
    override val trialComponentArn: Option[TrialComponentArn] = scala
      .Option(impl.trialComponentArn())
      .map(value => zio.aws.sagemaker.model.primitives.TrialComponentArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateTrialComponentResponse
  ): zio.aws.sagemaker.model.CreateTrialComponentResponse.ReadOnly =
    new Wrapper(impl)
}
